/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.skydoc;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Functions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.devtools.build.lib.cmdline.Label;
import com.google.devtools.build.lib.cmdline.LabelSyntaxException;
import com.google.devtools.build.lib.cmdline.RepositoryMapping;
import com.google.devtools.build.lib.collect.nestedset.Depset;
import com.google.devtools.build.lib.collect.nestedset.NestedSetBuilder;
import com.google.devtools.build.lib.collect.nestedset.Order;
import com.google.devtools.build.lib.events.Event;
import com.google.devtools.build.lib.events.EventHandler;
import com.google.devtools.build.lib.packages.semantics.BuildLanguageOptions;
import com.google.devtools.build.runfiles.Runfiles;
import com.google.devtools.build.runfiles.RunfilesForStardoc;
import com.google.devtools.build.skydoc.SkydocOptions;
import com.google.devtools.build.skydoc.SystemOutEventHandler;
import com.google.devtools.build.skydoc.fakebuildapi.FakeApi;
import com.google.devtools.build.skydoc.fakebuildapi.FakeDeepStructure;
import com.google.devtools.build.skydoc.fakebuildapi.FakeProviderApi;
import com.google.devtools.build.skydoc.fakebuildapi.FakeStructApi;
import com.google.devtools.build.skydoc.rendering.AspectInfoWrapper;
import com.google.devtools.build.skydoc.rendering.DocstringParseException;
import com.google.devtools.build.skydoc.rendering.ProtoRenderer;
import com.google.devtools.build.skydoc.rendering.ProviderInfoWrapper;
import com.google.devtools.build.skydoc.rendering.RuleInfoWrapper;
import com.google.devtools.build.skydoc.rendering.proto.StardocOutputProtos;
import com.google.devtools.common.options.OptionsParser;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import net.starlark.java.annot.Param;
import net.starlark.java.annot.StarlarkBuiltin;
import net.starlark.java.annot.StarlarkMethod;
import net.starlark.java.eval.Dict;
import net.starlark.java.eval.EvalException;
import net.starlark.java.eval.Module;
import net.starlark.java.eval.Mutability;
import net.starlark.java.eval.Starlark;
import net.starlark.java.eval.StarlarkCallable;
import net.starlark.java.eval.StarlarkFunction;
import net.starlark.java.eval.StarlarkSemantics;
import net.starlark.java.eval.StarlarkThread;
import net.starlark.java.eval.StarlarkValue;
import net.starlark.java.lib.json.Json;
import net.starlark.java.syntax.FileOptions;
import net.starlark.java.syntax.ParserInput;
import net.starlark.java.syntax.Program;
import net.starlark.java.syntax.Resolver;
import net.starlark.java.syntax.StarlarkFile;
import net.starlark.java.syntax.SyntaxError;

public class SkydocMain {
    private final EventHandler eventHandler = new SystemOutEventHandler();
    private final LinkedHashSet<Path> pending = new LinkedHashSet();
    private final Map<Path, Module> loaded = new HashMap<Path, Module>();
    private final String workspaceName;
    private final Runfiles.Preloaded runfiles;

    public SkydocMain(String workspaceName, Runfiles.Preloaded runfiles) {
        this.workspaceName = workspaceName;
        this.runfiles = runfiles;
    }

    public static void main(String[] args) throws IOException, InterruptedException, LabelSyntaxException, DocstringParseException {
        OptionsParser parser = OptionsParser.builder().optionsClasses(BuildLanguageOptions.class, SkydocOptions.class).build();
        parser.parseAndExitUponError(args);
        BuildLanguageOptions semanticsOptions = parser.getOptions(BuildLanguageOptions.class);
        semanticsOptions.incompatibleNewActionsApi = false;
        SkydocOptions skydocOptions = parser.getOptions(SkydocOptions.class);
        if (Strings.isNullOrEmpty(skydocOptions.targetFileLabel) || Strings.isNullOrEmpty(skydocOptions.outputFilePath)) {
            throw new IllegalArgumentException("Expected a target file label and an output file path.");
        }
        String targetFileLabelString = skydocOptions.targetFileLabel;
        String outputPath = skydocOptions.outputFilePath;
        Label targetFileLabel = Label.parseCanonical(targetFileLabelString);
        ImmutableMap.Builder<String, StardocOutputProtos.RuleInfo> ruleInfoMap = ImmutableMap.builder();
        ImmutableMap.Builder<String, StardocOutputProtos.ProviderInfo> providerInfoMap = ImmutableMap.builder();
        ImmutableMap.Builder<String, StarlarkFunction> userDefinedFunctions = ImmutableMap.builder();
        ImmutableMap.Builder<String, StardocOutputProtos.AspectInfo> aspectInfoMap = ImmutableMap.builder();
        Module module = null;
        try {
            module = new SkydocMain(skydocOptions.workspaceName, Runfiles.preload()).eval(semanticsOptions.toStarlarkSemantics(), targetFileLabel, ruleInfoMap, providerInfoMap, userDefinedFunctions, aspectInfoMap);
        }
        catch (StarlarkEvaluationException | EvalException exception) {
            exception.printStackTrace();
            System.err.println("Stardoc documentation generation failed: " + exception.getMessage());
            System.exit(1);
        }
        ProtoRenderer renderer = SkydocMain.render(module, ImmutableSet.copyOf(skydocOptions.symbolNames), ruleInfoMap.buildOrThrow(), providerInfoMap.buildOrThrow(), userDefinedFunctions.buildOrThrow(), aspectInfoMap.buildOrThrow());
        try (BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(outputPath));){
            renderer.writeModuleInfo(out);
        }
    }

    private static boolean validSymbolName(ImmutableSet<String> symbolNames, String symbolName) {
        if (symbolNames.isEmpty()) {
            return !symbolName.startsWith("_");
        }
        if (symbolNames.contains(symbolName)) {
            return true;
        }
        if (symbolName.contains(".")) {
            return symbolNames.contains(symbolName.substring(0, symbolName.indexOf(46)));
        }
        return false;
    }

    @VisibleForTesting
    public static ProtoRenderer render(Module module, ImmutableSet<String> symbolNames, ImmutableMap<String, StardocOutputProtos.RuleInfo> ruleInfoMap, ImmutableMap<String, StardocOutputProtos.ProviderInfo> providerInfoMap, ImmutableMap<String, StarlarkFunction> userDefinedFunctions, ImmutableMap<String, StardocOutputProtos.AspectInfo> aspectInfoMap) throws DocstringParseException {
        ImmutableMap<String, StardocOutputProtos.RuleInfo> filteredRuleInfos = ruleInfoMap.entrySet().stream().filter(entry -> SkydocMain.validSymbolName(symbolNames, (String)entry.getKey())).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue));
        ImmutableMap<String, StardocOutputProtos.ProviderInfo> filteredProviderInfos = providerInfoMap.entrySet().stream().filter(entry -> SkydocMain.validSymbolName(symbolNames, (String)entry.getKey())).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue));
        ImmutableMap<String, StarlarkFunction> filteredStarlarkFunctions = userDefinedFunctions.entrySet().stream().filter(entry -> SkydocMain.validSymbolName(symbolNames, (String)entry.getKey())).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue));
        ImmutableMap<String, StardocOutputProtos.AspectInfo> filteredAspectInfos = aspectInfoMap.entrySet().stream().filter(entry -> SkydocMain.validSymbolName(symbolNames, (String)entry.getKey())).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue));
        String moduleDocstring = module.getDocumentation();
        if (moduleDocstring == null) {
            moduleDocstring = "";
        }
        return new ProtoRenderer().appendRuleInfos(filteredRuleInfos.values()).appendProviderInfos(filteredProviderInfos.values()).appendStarlarkFunctionInfos(filteredStarlarkFunctions).appendAspectInfos(filteredAspectInfos.values()).setModuleDocstring(moduleDocstring);
    }

    @VisibleForTesting
    public Module eval(StarlarkSemantics semantics, Label canonicalLabel, ImmutableMap.Builder<String, StardocOutputProtos.RuleInfo> ruleInfoMap, ImmutableMap.Builder<String, StardocOutputProtos.ProviderInfo> providerInfoMap, ImmutableMap.Builder<String, StarlarkFunction> userDefinedFunctionMap, ImmutableMap.Builder<String, StardocOutputProtos.AspectInfo> aspectInfoMap) throws InterruptedException, IOException, LabelSyntaxException, EvalException, StarlarkEvaluationException {
        ArrayList<RuleInfoWrapper> ruleInfoList = new ArrayList<RuleInfoWrapper>();
        ArrayList<ProviderInfoWrapper> providerInfoList = new ArrayList<ProviderInfoWrapper>();
        ArrayList<AspectInfoWrapper> aspectInfoList = new ArrayList<AspectInfoWrapper>();
        Module module = this.recursiveEval(semantics, canonicalLabel, ruleInfoList, providerInfoList, aspectInfoList);
        Map<StarlarkCallable, RuleInfoWrapper> ruleFunctions = ruleInfoList.stream().collect(Collectors.toMap(RuleInfoWrapper::getIdentifierFunction, Functions.identity()));
        Map providerInfos = providerInfoList.stream().collect(Collectors.toMap(ProviderInfoWrapper::getIdentifier, Functions.identity()));
        Map aspectFunctions = aspectInfoList.stream().collect(Collectors.toMap(AspectInfoWrapper::getIdentifierFunction, Functions.identity()));
        TreeMap<String, Object> sortedBindings = new TreeMap<String, Object>(module.getGlobals());
        for (Map.Entry<String, Object> envEntry : sortedBindings.entrySet()) {
            if (ruleFunctions.containsKey(envEntry.getValue())) {
                StardocOutputProtos.RuleInfo ruleInfo = ((RuleInfoWrapper)ruleFunctions.get(envEntry.getValue())).getRuleInfo().build();
                if ("".equals(ruleInfo.getRuleName())) {
                    ruleInfo = ruleInfo.toBuilder().setRuleName(envEntry.getKey()).build();
                }
                ruleInfoMap.put(ruleInfo.getRuleName(), ruleInfo);
            }
            if (providerInfos.containsKey(envEntry.getValue())) {
                StardocOutputProtos.ProviderInfo.Builder providerInfoBuild = ((ProviderInfoWrapper)providerInfos.get(envEntry.getValue())).getProviderInfo();
                StardocOutputProtos.ProviderInfo providerInfo = providerInfoBuild.setProviderName(envEntry.getKey()).build();
                providerInfoMap.put(envEntry.getKey(), providerInfo);
            }
            if (envEntry.getValue() instanceof StarlarkFunction) {
                StarlarkFunction userDefinedFunction = (StarlarkFunction)envEntry.getValue();
                userDefinedFunctionMap.put(envEntry.getKey(), userDefinedFunction);
            }
            if (envEntry.getValue() instanceof FakeStructApi) {
                String namespaceName = envEntry.getKey();
                FakeStructApi namespace = (FakeStructApi)envEntry.getValue();
                SkydocMain.putStructFields(namespaceName, namespace, ruleFunctions, ruleInfoMap, userDefinedFunctionMap);
            }
            if (!aspectFunctions.containsKey(envEntry.getValue())) continue;
            StardocOutputProtos.AspectInfo.Builder aspectInfoBuild = ((AspectInfoWrapper)aspectFunctions.get(envEntry.getValue())).getAspectInfo();
            StardocOutputProtos.AspectInfo aspectInfo = aspectInfoBuild.setAspectName(envEntry.getKey()).build();
            aspectInfoMap.put(envEntry.getKey(), aspectInfo);
        }
        return module;
    }

    private static void putStructFields(String namespaceName, FakeStructApi namespace, Map<StarlarkCallable, RuleInfoWrapper> ruleFunctions, ImmutableMap.Builder<String, StardocOutputProtos.RuleInfo> ruleInfoMap, ImmutableMap.Builder<String, StarlarkFunction> userDefinedFunctionMap) throws EvalException {
        for (String field : namespace.getFieldNames()) {
            String qualifiedFieldName = namespaceName + "." + field;
            if (ruleFunctions.containsKey(namespace.getValue(field))) {
                ruleInfoMap.put(qualifiedFieldName, ruleFunctions.get(namespace.getValue(field)).getRuleInfo().build());
                continue;
            }
            if (namespace.getValue(field) instanceof StarlarkFunction) {
                StarlarkFunction userDefinedFunction = (StarlarkFunction)namespace.getValue(field);
                userDefinedFunctionMap.put(qualifiedFieldName, userDefinedFunction);
                continue;
            }
            if (!(namespace.getValue(field) instanceof FakeStructApi)) continue;
            FakeStructApi innerNamespace = (FakeStructApi)namespace.getValue(field);
            SkydocMain.putStructFields(qualifiedFieldName, innerNamespace, ruleFunctions, ruleInfoMap, userDefinedFunctionMap);
        }
    }

    private Module recursiveEval(StarlarkSemantics semantics, Label canonicalLabel, List<RuleInfoWrapper> ruleInfoList, List<ProviderInfoWrapper> providerInfoList, List<AspectInfoWrapper> aspectInfoList) throws InterruptedException, IOException, LabelSyntaxException, StarlarkEvaluationException {
        Program prog;
        Path path = this.pathOfCanonicalLabel(canonicalLabel);
        String sourceRepository = canonicalLabel.getRepository().getName();
        if (this.pending.contains(path)) {
            throw new StarlarkEvaluationException("cycle with " + path);
        }
        if (this.loaded.containsKey(path)) {
            return this.loaded.get(path);
        }
        this.pending.add(path);
        ImmutableMap.Builder<String, Object> initialEnvBuilder = ImmutableMap.builder();
        FakeApi.addPredeclared(initialEnvBuilder, ruleInfoList, providerInfoList, aspectInfoList);
        SkydocMain.addMorePredeclared(initialEnvBuilder);
        ImmutableMap<String, Object> initialEnv = initialEnvBuilder.build();
        HashMap<String, Object> predeclaredSymbols = new HashMap<String, Object>();
        predeclaredSymbols.putAll(initialEnv);
        Resolver.Module predeclaredResolver = name -> {
            if (predeclaredSymbols.containsKey(name)) {
                return Resolver.Scope.PREDECLARED;
            }
            if (!Starlark.UNIVERSE.containsKey(name)) {
                predeclaredSymbols.put(name, FakeDeepStructure.create(name));
                return Resolver.Scope.PREDECLARED;
            }
            return Resolver.Scope.UNIVERSAL;
        };
        ParserInput input = ParserInput.fromLatin1(Files.readAllBytes(path), path.toString());
        try {
            StarlarkFile file = StarlarkFile.parse(input, FileOptions.DEFAULT);
            prog = Program.compileFile(file, predeclaredResolver);
        }
        catch (SyntaxError.Exception ex) {
            Event.replayEventsOn(this.eventHandler, ex.errors());
            throw new StarlarkEvaluationException(ex.getMessage());
        }
        HashMap<String, Module> imports = new HashMap<String, Module>();
        for (String load : prog.getLoads()) {
            Label apparentLoad = Label.parseWithPackageContext(load, Label.PackageContext.of(canonicalLabel.getPackageIdentifier(), RepositoryMapping.ALWAYS_FALLBACK));
            Label canonicalLoad = this.toCanonicalLabel(apparentLoad, sourceRepository);
            try {
                Module loadedModule = this.recursiveEval(semantics, canonicalLoad, ruleInfoList, providerInfoList, aspectInfoList);
                imports.put(load, loadedModule);
            }
            catch (NoSuchFileException noSuchFileException) {
                throw new StarlarkEvaluationException(String.format("File %s imported '%s', yet %s was not found.", path, load, this.pathOfCanonicalLabel(canonicalLoad)), noSuchFileException);
            }
        }
        Module module = Module.withPredeclared(semantics, predeclaredSymbols);
        try (Mutability mu = Mutability.create("Skydoc");){
            StarlarkThread thread = new StarlarkThread(mu, semantics);
            thread.setLoader(imports::get);
            thread.setPostAssignHook((name, value) -> {
                if (value instanceof FakeProviderApi) {
                    ((FakeProviderApi)value).setName(name);
                }
            });
            Starlark.execFileProgram(prog, module, thread);
        }
        catch (EvalException ex) {
            throw new StarlarkEvaluationException(ex.getMessageWithStack());
        }
        this.pending.remove(path);
        this.loaded.put(path, module);
        return module;
    }

    private Label toCanonicalLabel(Label apparentLabel, String sourceRepository) {
        String canonicalRepositoryName = RunfilesForStardoc.getCanonicalRepositoryName(this.runfiles.withSourceRepository(sourceRepository), apparentLabel.getRepository().getName());
        return Label.parseCanonicalUnchecked(String.format("@%s//%s:%s", canonicalRepositoryName, apparentLabel.getPackageIdentifier().getPackageFragment().getPathString(), apparentLabel.getName()));
    }

    private Path pathOfCanonicalLabel(Label label) {
        String runfilesDirName = label.getRepository().isMain() ? this.workspaceName : label.getRepository().getName();
        String rlocationPath = runfilesDirName + "/" + label.toPathFragment();
        return Paths.get(this.runfiles.unmapped().rlocation(rlocationPath), new String[0]);
    }

    private static void addMorePredeclared(ImmutableMap.Builder<String, Object> env) {
        env.put("json", Json.INSTANCE);
        env.put("proto", new ProtoModule());
        env.put("depset", new StarlarkCallable(){

            @Override
            public Object fastcall(StarlarkThread thread, Object[] positional, Object[] named) {
                return Depset.of(Object.class, NestedSetBuilder.emptySet(Order.STABLE_ORDER));
            }

            @Override
            public String getName() {
                return "depset";
            }
        });
        env.put("select", new StarlarkCallable(){

            @Override
            public Object fastcall(StarlarkThread thread, Object[] positional, Object[] named) throws EvalException {
                Iterator iterator = ((Dict)positional[0]).entrySet().iterator();
                if (iterator.hasNext()) {
                    Map.Entry e = iterator.next();
                    return e.getValue();
                }
                throw Starlark.errorf("select: empty dict", new Object[0]);
            }

            @Override
            public String getName() {
                return "select";
            }
        });
    }

    @VisibleForTesting
    static class StarlarkEvaluationException
    extends Exception {
        public StarlarkEvaluationException(String message) {
            super(message);
        }

        public StarlarkEvaluationException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    @StarlarkBuiltin(name="ProtoModule", documented=false)
    private static final class ProtoModule
    implements StarlarkValue {
        private ProtoModule() {
        }

        @StarlarkMethod(name="encode_text", doc=".", parameters={@Param(name="x")})
        public String encodeText(Object x) {
            return "";
        }
    }
}

