/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.worker;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.devtools.build.lib.buildeventstream.BuildEventStreamProtos;
import com.google.devtools.build.lib.clock.Clock;
import com.google.devtools.build.lib.metrics.PsInfoCollector;
import com.google.devtools.build.lib.util.OS;
import com.google.devtools.build.lib.worker.WorkerMetric;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class WorkerMetricsCollector {
    private static final WorkerMetricsCollector instance = new WorkerMetricsCollector();
    private Clock clock;
    private final Map<Long, WorkerMetric.WorkerProperties> processIdToWorkerProperties = new ConcurrentHashMap<Long, WorkerMetric.WorkerProperties>();
    private final Map<Long, Instant> workerLastCallTime = new ConcurrentHashMap<Long, Instant>();

    private WorkerMetricsCollector() {
    }

    public static WorkerMetricsCollector instance() {
        return instance;
    }

    public void setClock(Clock clock) {
        this.clock = clock;
    }

    PsInfoCollector.ResourceSnapshot collectMemoryUsageByPid(OS os, ImmutableSet<Long> processIds) {
        if (processIds.isEmpty() || os != OS.LINUX && os != OS.DARWIN) {
            return PsInfoCollector.ResourceSnapshot.create(ImmutableMap.of(), Instant.now());
        }
        return PsInfoCollector.instance().collectResourceUsage(processIds);
    }

    public ImmutableList<WorkerMetric> collectMetrics() {
        PsInfoCollector.ResourceSnapshot resourceSnapshot = this.collectMemoryUsageByPid(OS.getCurrent(), ImmutableSet.copyOf(this.processIdToWorkerProperties.keySet()));
        return this.buildWorkerMetrics(resourceSnapshot);
    }

    private ImmutableList<WorkerMetric> buildWorkerMetrics(PsInfoCollector.ResourceSnapshot resourceSnapshot) {
        ImmutableMap<Long, Integer> pidToMemoryInKb = resourceSnapshot.getPidToMemoryInKb();
        Instant collectionTime = resourceSnapshot.getCollectionTime();
        ImmutableList.Builder workerMetrics = new ImmutableList.Builder();
        ArrayList<Long> nonMeasurableProcessIds = new ArrayList<Long>();
        for (WorkerMetric.WorkerProperties workerProperties : this.processIdToWorkerProperties.values()) {
            Long pid = workerProperties.getProcessId();
            WorkerMetric.WorkerStat workerStats = WorkerMetric.WorkerStat.create(pidToMemoryInKb.getOrDefault(pid, 0), this.workerLastCallTime.get(pid), collectionTime);
            workerMetrics.add(WorkerMetric.create(workerProperties, workerStats, pidToMemoryInKb.containsKey(pid)));
            if (pidToMemoryInKb.containsKey(pid)) continue;
            nonMeasurableProcessIds.add(pid);
        }
        this.processIdToWorkerProperties.keySet().removeAll(nonMeasurableProcessIds);
        return workerMetrics.build();
    }

    public ImmutableList<BuildEventStreamProtos.BuildMetrics.WorkerMetrics> createWorkerMetricsProto() {
        return this.collectMetrics().stream().map(WorkerMetric::toProto).collect(ImmutableList.toImmutableList());
    }

    public void clear() {
        this.processIdToWorkerProperties.clear();
        this.workerLastCallTime.clear();
    }

    @VisibleForTesting
    Map<Long, WorkerMetric.WorkerProperties> getProcessIdToWorkerProperties() {
        return this.processIdToWorkerProperties;
    }

    @VisibleForTesting
    Map<Long, Instant> getWorkerLastCallTime() {
        return this.workerLastCallTime;
    }

    public synchronized void registerWorker(int workerId, long processId, String mnemonic, boolean isMultiplex, boolean isSandboxed, int workerKeyHash) {
        WorkerMetric.WorkerProperties existingWorkerProperties = this.processIdToWorkerProperties.get(processId);
        this.workerLastCallTime.put(processId, Instant.ofEpochMilli(this.clock.currentTimeMillis()));
        if (existingWorkerProperties == null) {
            this.processIdToWorkerProperties.put(processId, WorkerMetric.WorkerProperties.create(ImmutableList.of(Integer.valueOf(workerId)), processId, mnemonic, isMultiplex, isSandboxed, workerKeyHash));
            return;
        }
        if (existingWorkerProperties.getWorkerIds().contains(workerId)) {
            return;
        }
        ImmutableCollection updatedWorkerIds = ((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll(existingWorkerProperties.getWorkerIds())).add((Object)workerId)).build();
        WorkerMetric.WorkerProperties updatedWorkerProperties = WorkerMetric.WorkerProperties.create((ImmutableList<Integer>)updatedWorkerIds, processId, mnemonic, isMultiplex, isSandboxed, workerKeyHash);
        this.processIdToWorkerProperties.put(processId, updatedWorkerProperties);
    }
}

