/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.worker;

import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import com.google.devtools.build.lib.buildeventstream.BuildEventStreamProtos;
import com.google.devtools.build.lib.worker.AutoValue_WorkerMetric;
import com.google.devtools.build.lib.worker.AutoValue_WorkerMetric_WorkerProperties;
import com.google.devtools.build.lib.worker.AutoValue_WorkerMetric_WorkerStat;
import java.time.Instant;

@AutoValue
public abstract class WorkerMetric {
    public abstract WorkerProperties getWorkerProperties();

    public abstract WorkerStat getWorkerStat();

    public abstract boolean isMeasurable();

    public static WorkerMetric create(WorkerProperties workerProperties, WorkerStat workerStat, boolean isMeasurable) {
        return new AutoValue_WorkerMetric(workerProperties, workerStat, isMeasurable);
    }

    public BuildEventStreamProtos.BuildMetrics.WorkerMetrics toProto() {
        WorkerProperties workerProperties = this.getWorkerProperties();
        WorkerStat workerStat = this.getWorkerStat();
        BuildEventStreamProtos.BuildMetrics.WorkerMetrics.Builder builder = BuildEventStreamProtos.BuildMetrics.WorkerMetrics.newBuilder().addAllWorkerIds(workerProperties.getWorkerIds()).setProcessId((int)workerProperties.getProcessId()).setMnemonic(workerProperties.getMnemonic()).setIsSandbox(workerProperties.isSandboxed()).setIsMultiplex(workerProperties.isMultiplex()).setIsMeasurable(this.isMeasurable());
        if (workerStat != null) {
            BuildEventStreamProtos.BuildMetrics.WorkerMetrics.WorkerStats stats = BuildEventStreamProtos.BuildMetrics.WorkerMetrics.WorkerStats.newBuilder().setCollectTimeInMs(workerStat.getCollectTime().toEpochMilli()).setWorkerMemoryInKb(workerStat.getUsedMemoryInKB()).setLastActionStartTimeInMs(workerStat.getLastCallTime().toEpochMilli()).build();
            builder.addWorkerStats(stats);
        }
        return builder.build();
    }

    @AutoValue
    public static abstract class WorkerProperties {
        public abstract ImmutableList<Integer> getWorkerIds();

        public abstract long getProcessId();

        public abstract String getMnemonic();

        public abstract boolean isMultiplex();

        public abstract boolean isSandboxed();

        public abstract int getWorkerKeylHash();

        public static WorkerProperties create(ImmutableList<Integer> workerIds, long processId, String mnemonic, boolean isMultiplex, boolean isSandboxed, int workerKeyHash) {
            return new AutoValue_WorkerMetric_WorkerProperties(workerIds, processId, mnemonic, isMultiplex, isSandboxed, workerKeyHash);
        }
    }

    @AutoValue
    public static abstract class WorkerStat {
        public abstract int getUsedMemoryInKB();

        public abstract Instant getLastCallTime();

        public abstract Instant getCollectTime();

        public static WorkerStat create(int usedMemoryInKB, Instant lastCallTime, Instant collectTime) {
            return new AutoValue_WorkerMetric_WorkerStat(usedMemoryInKB, lastCallTime, collectTime);
        }
    }
}

