/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.windows;

import com.google.devtools.build.lib.jni.JniLoader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.AccessDeniedException;
import java.nio.file.DirectoryNotEmptyException;

public class WindowsFileOperations {
    private static final int MAX_PATH = 260;
    private static final int IS_SYMLINK_OR_JUNCTION_SUCCESS = 0;
    private static final int IS_SYMLINK_OR_JUNCTION_DOES_NOT_EXIST = 2;
    private static final int GET_CHANGE_TIME_SUCCESS = 0;
    private static final int GET_CHANGE_TIME_DOES_NOT_EXIST = 2;
    private static final int GET_CHANGE_TIME_ACCESS_DENIED = 3;
    private static final int CREATE_JUNCTION_SUCCESS = 0;
    private static final int CREATE_JUNCTION_TARGET_NAME_TOO_LONG = 2;
    private static final int CREATE_JUNCTION_ALREADY_EXISTS_WITH_DIFFERENT_TARGET = 3;
    private static final int CREATE_JUNCTION_ALREADY_EXISTS_BUT_NOT_A_JUNCTION = 4;
    private static final int CREATE_JUNCTION_ACCESS_DENIED = 5;
    private static final int CREATE_JUNCTION_DISAPPEARED = 6;
    private static final int CREATE_SYMLINK_SUCCESS = 0;
    private static final int CREATE_SYMLINK_TARGET_IS_DIRECTORY = 2;
    private static final int DELETE_PATH_SUCCESS = 0;
    private static final int DELETE_PATH_DOES_NOT_EXIST = 2;
    private static final int DELETE_PATH_DIRECTORY_NOT_EMPTY = 3;
    private static final int DELETE_PATH_ACCESS_DENIED = 4;
    private static final int READ_SYMLINK_OR_JUNCTION_SUCCESS = 0;
    private static final int READ_SYMLINK_OR_JUNCTION_ACCESS_DENIED = 2;
    private static final int READ_SYMLINK_OR_JUNCTION_DOES_NOT_EXIST = 3;
    private static final int READ_SYMLINK_OR_JUNCTION_NOT_A_LINK = 4;
    private static final int READ_SYMLINK_OR_JUNCTION_UNKNOWN_LINK_TYPE = 5;

    private WindowsFileOperations() {
    }

    private static native int nativeIsSymlinkOrJunction(String var0, boolean[] var1, String[] var2);

    private static native int nativeGetChangeTime(String var0, boolean var1, long[] var2, String[] var3);

    private static native boolean nativeGetLongPath(String var0, String[] var1, String[] var2);

    private static native int nativeCreateJunction(String var0, String var1, String[] var2);

    private static native int nativeCreateSymlink(String var0, String var1, String[] var2);

    private static native int nativeReadSymlinkOrJunction(String var0, String[] var1, String[] var2);

    private static native int nativeDeletePath(String var0, String[] var1);

    public static boolean isSymlinkOrJunction(String path) throws IOException {
        boolean[] result = new boolean[]{false};
        String[] error = new String[]{null};
        switch (WindowsFileOperations.nativeIsSymlinkOrJunction(WindowsFileOperations.asLongPath(path), result, error)) {
            case 0: {
                return result[0];
            }
            case 2: {
                error[0] = "path does not exist";
                break;
            }
        }
        throw new IOException(String.format("Cannot tell if '%s' is link: %s", path, error[0]));
    }

    public static long getLastChangeTime(String path, boolean followReparsePoints) throws IOException {
        long[] result = new long[]{0L};
        String[] error = new String[]{null};
        switch (WindowsFileOperations.nativeGetChangeTime(WindowsFileOperations.asLongPath(path), followReparsePoints, result, error)) {
            case 0: {
                return result[0];
            }
            case 2: {
                throw new FileNotFoundException(path);
            }
            case 3: {
                throw new AccessDeniedException(path);
            }
        }
        throw new IOException(String.format("Cannot get last change time of '%s': %s", path, error[0]));
    }

    public static String getLongPath(String path) throws IOException {
        String[] result = new String[]{null};
        String[] error = new String[]{null};
        if (WindowsFileOperations.nativeGetLongPath(WindowsFileOperations.asLongPath(path), result, error)) {
            return WindowsFileOperations.removeUncPrefixAndUseSlashes(result[0]);
        }
        throw new IOException(error[0]);
    }

    static String asLongPath(String path) {
        return !path.startsWith("\\\\?\\") ? "\\\\?\\" + path.replace('/', '\\') : path.replace('/', '\\');
    }

    private static String removeUncPrefixAndUseSlashes(String p) {
        if (p.length() >= 4 && p.charAt(0) == '\\' && (p.charAt(1) == '\\' || p.charAt(1) == '?') && p.charAt(2) == '?' && p.charAt(3) == '\\') {
            p = p.substring(4);
        }
        return p.replace('\\', '/');
    }

    public static void createJunction(String name, String target) throws IOException {
        String[] error = new String[]{null};
        switch (WindowsFileOperations.nativeCreateJunction(WindowsFileOperations.asLongPath(name), WindowsFileOperations.asLongPath(target), error)) {
            case 0: {
                return;
            }
            case 2: {
                error[0] = "target name is too long";
                break;
            }
            case 3: {
                error[0] = "junction already exists with different target";
                break;
            }
            case 4: {
                error[0] = "a file or directory already exists at the junction's path";
                break;
            }
            case 5: {
                error[0] = "access is denied";
                break;
            }
            case 6: {
                error[0] = "the junction's path got modified unexpectedly";
                break;
            }
        }
        throw new IOException(String.format("Cannot create junction (name=%s, target=%s): %s", name, target, error[0]));
    }

    public static void createSymlink(String name, String target) throws IOException {
        String[] error = new String[]{null};
        switch (WindowsFileOperations.nativeCreateSymlink(WindowsFileOperations.asLongPath(name), WindowsFileOperations.asLongPath(target), error)) {
            case 0: {
                return;
            }
            case 2: {
                error[0] = "symlink target is a directory, use a junction";
                break;
            }
        }
        throw new IOException(String.format("Cannot create symlink (name=%s, target=%s): %s", name, target, error[0]));
    }

    public static ReadSymlinkOrJunctionResult readSymlinkOrJunction(String name) {
        String[] target = new String[]{null};
        String[] error = new String[]{null};
        switch (WindowsFileOperations.nativeReadSymlinkOrJunction(WindowsFileOperations.asLongPath(name), target, error)) {
            case 0: {
                return new ReadSymlinkOrJunctionResult(ReadSymlinkOrJunctionResult.Status.OK, WindowsFileOperations.removeUncPrefixAndUseSlashes(target[0]));
            }
            case 2: {
                error[0] = "access is denied";
                break;
            }
            case 3: {
                error[0] = "path does not exist";
                break;
            }
            case 4: {
                return new ReadSymlinkOrJunctionResult(ReadSymlinkOrJunctionResult.Status.NOT_A_LINK, "path is not a link");
            }
            case 5: {
                error[0] = "unknown link type";
                break;
            }
        }
        return new ReadSymlinkOrJunctionResult(ReadSymlinkOrJunctionResult.Status.ERROR, String.format("Cannot read link (name=%s): %s", name, error[0]));
    }

    public static boolean deletePath(String path) throws IOException {
        String[] error = new String[]{null};
        int result = WindowsFileOperations.nativeDeletePath(WindowsFileOperations.asLongPath(path), error);
        switch (result) {
            case 0: {
                return true;
            }
            case 2: {
                return false;
            }
            case 3: {
                throw new DirectoryNotEmptyException(path);
            }
            case 4: {
                throw new AccessDeniedException(path);
            }
        }
        throw new IOException(String.format("Cannot delete path '%s': %s", path, error[0]));
    }

    static {
        JniLoader.loadJni();
    }

    public static class ReadSymlinkOrJunctionResult {
        private String result;
        private Status status;

        public ReadSymlinkOrJunctionResult(Status s2, String r) {
            this.status = s2;
            this.result = r;
        }

        public String getResult() {
            return this.result;
        }

        public Status getStatus() {
            return this.status;
        }

        public static enum Status {
            OK,
            NOT_A_LINK,
            ERROR;

        }
    }
}

