/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.vfs;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.google.devtools.build.lib.vfs.OsPathPolicy;
import com.google.devtools.build.lib.windows.WindowsFileOperations;
import com.google.devtools.build.lib.windows.WindowsShortPath;
import java.io.IOException;

@VisibleForTesting
class WindowsOsPathPolicy
implements OsPathPolicy {
    static final WindowsOsPathPolicy INSTANCE = new WindowsOsPathPolicy();
    static final int NEEDS_SHORT_PATH_NORMALIZATION = 2;
    private static final Splitter WINDOWS_PATH_SPLITTER = Splitter.onPattern("[\\\\/]+").omitEmptyStrings();
    private final ShortPathResolver shortPathResolver;

    WindowsOsPathPolicy() {
        this(new DefaultShortPathResolver());
    }

    WindowsOsPathPolicy(ShortPathResolver shortPathResolver) {
        this.shortPathResolver = shortPathResolver;
    }

    @Override
    public int needsToNormalize(String path) {
        int n = path.length();
        int normalizationLevel = 0;
        int dotCount = 0;
        char prevChar = '\u0000';
        int segmentBeginIndex = 0;
        boolean segmentHasShortPathChar = false;
        for (int i = 0; i < n; ++i) {
            char c = path.charAt(i);
            if (this.isSeparator(c)) {
                if (c == '\\') {
                    normalizationLevel = Math.max(normalizationLevel, 1);
                }
                if (prevChar == '/') {
                    normalizationLevel = Math.max(normalizationLevel, 1);
                }
                if (dotCount == 1 || dotCount == 2) {
                    normalizationLevel = Math.max(normalizationLevel, 1);
                }
                if (segmentHasShortPathChar && WindowsShortPath.isShortPath(path.substring(segmentBeginIndex, i))) {
                    normalizationLevel = Math.max(normalizationLevel, 2);
                }
                segmentBeginIndex = i + 1;
                segmentHasShortPathChar = false;
            } else if (c == '~') {
                segmentHasShortPathChar = true;
            }
            dotCount = c == '.' ? dotCount + 1 : 0;
            prevChar = c;
        }
        if (segmentHasShortPathChar && WindowsShortPath.isShortPath(path.substring(segmentBeginIndex))) {
            normalizationLevel = Math.max(normalizationLevel, 2);
        }
        if (n > 1 && this.isSeparator(prevChar) || dotCount == 1 || dotCount == 2) {
            normalizationLevel = Math.max(normalizationLevel, 1);
        }
        return normalizationLevel;
    }

    @Override
    public int needsToNormalizeSuffix(String normalizedSuffix) {
        return this.needsToNormalize(normalizedSuffix);
    }

    @Override
    public String normalize(String path, int normalizationLevel) {
        String resolvedPath;
        if (normalizationLevel == 0) {
            return path;
        }
        if (normalizationLevel == 2 && (resolvedPath = this.shortPathResolver.resolveShortPath(path)) != null) {
            path = resolvedPath;
        }
        String[] segments = Iterables.toArray(WINDOWS_PATH_SPLITTER.splitToList(path), String.class);
        int driveStrLength = this.getDriveStrLength(path);
        boolean isAbsolute = driveStrLength > 0;
        int segmentSkipCount = isAbsolute && driveStrLength > 1 ? 1 : 0;
        StringBuilder sb = new StringBuilder(path.length());
        if (isAbsolute) {
            char c = path.charAt(0);
            if (this.isSeparator(c)) {
                sb.append('/');
            } else {
                sb.append(Character.toUpperCase(c));
                sb.append(":/");
            }
        }
        int segmentCount = OsPathPolicy.Utils.removeRelativePaths(segments, segmentSkipCount, isAbsolute);
        for (int i = 0; i < segmentCount; ++i) {
            sb.append(segments[i]);
            sb.append('/');
        }
        if (segmentCount > 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    @Override
    public int getDriveStrLength(String path) {
        int n = path.length();
        if (n == 0) {
            return 0;
        }
        char c0 = path.charAt(0);
        if (this.isSeparator(c0)) {
            return 1;
        }
        if (n < 3) {
            return 0;
        }
        char c1 = path.charAt(1);
        char c2 = path.charAt(2);
        if (WindowsOsPathPolicy.isDriveLetter(c0) && c1 == ':' && this.isSeparator(c2)) {
            return 3;
        }
        return 0;
    }

    private static boolean isDriveLetter(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z';
    }

    @Override
    public int compare(String s1, String s2) {
        return s1.compareToIgnoreCase(s2);
    }

    @Override
    public int compare(char c1, char c2) {
        return Character.compare(Character.toLowerCase(c1), Character.toLowerCase(c2));
    }

    @Override
    public boolean equals(String s1, String s2) {
        return s1 == null && s2 == null || s1 != null && s1.equalsIgnoreCase(s2);
    }

    @Override
    public int hash(String s2) {
        if (s2 == null) {
            return 0;
        }
        return s2.toLowerCase().hashCode();
    }

    @Override
    public boolean startsWith(String path, String prefix) {
        int prefixn;
        int pathn = path.length();
        if (pathn < (prefixn = prefix.length())) {
            return false;
        }
        for (int i = 0; i < prefixn; ++i) {
            if (Character.toLowerCase(path.charAt(i)) == Character.toLowerCase(prefix.charAt(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean endsWith(String path, String suffix) {
        int suffixLength;
        int pathn = path.length();
        if (pathn < (suffixLength = suffix.length())) {
            return false;
        }
        int offset = pathn - suffixLength;
        for (int i = 0; i < suffixLength; ++i) {
            if (Character.toLowerCase(path.charAt(i + offset)) == Character.toLowerCase(suffix.charAt(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isSeparator(char c) {
        return c == '/' || c == '\\';
    }

    @Override
    public char additionalSeparator() {
        return '\\';
    }

    @Override
    public boolean isCaseSensitive() {
        return false;
    }

    static class DefaultShortPathResolver
    implements ShortPathResolver {
        DefaultShortPathResolver() {
        }

        @Override
        public String resolveShortPath(String path) {
            try {
                return WindowsFileOperations.getLongPath(path);
            }
            catch (IOException e) {
                return path;
            }
        }
    }

    static interface ShortPathResolver {
        public String resolveShortPath(String var1);
    }
}

