/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.vfs;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.google.devtools.build.lib.vfs.OsPathPolicy;
import java.util.Objects;

@VisibleForTesting
class UnixOsPathPolicy
implements OsPathPolicy {
    static final UnixOsPathPolicy INSTANCE = new UnixOsPathPolicy();
    private static final Splitter PATH_SPLITTER = Splitter.onPattern("/+").omitEmptyStrings();

    UnixOsPathPolicy() {
    }

    @Override
    public int needsToNormalize(String path) {
        int n = path.length();
        int dotCount = 0;
        int prevChar = 0;
        for (int i = 0; i < n; ++i) {
            char c = path.charAt(i);
            if (c == '\\') {
                return 1;
            }
            if (c == '/') {
                if (prevChar == 47) {
                    return 1;
                }
                if (dotCount == 1 || dotCount == 2) {
                    return 1;
                }
            }
            dotCount = c == '.' ? dotCount + 1 : 0;
            prevChar = c;
        }
        if (prevChar == 47 || dotCount == 1 || dotCount == 2) {
            return 1;
        }
        return 0;
    }

    @Override
    public int needsToNormalizeSuffix(String normalizedSuffix) {
        return normalizedSuffix.startsWith("..") ? 1 : 0;
    }

    @Override
    public String normalize(String path, int normalizationLevel) {
        if (normalizationLevel == 0) {
            return path;
        }
        if (path.isEmpty()) {
            return path;
        }
        boolean isAbsolute = path.charAt(0) == '/';
        StringBuilder sb = new StringBuilder(path.length());
        if (isAbsolute) {
            sb.append('/');
        }
        String[] segments = Iterables.toArray(PATH_SPLITTER.splitToList(path), String.class);
        int segmentCount = OsPathPolicy.Utils.removeRelativePaths(segments, 0, isAbsolute);
        for (int i = 0; i < segmentCount; ++i) {
            sb.append(segments[i]);
            sb.append('/');
        }
        if (segmentCount > 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    @Override
    public int getDriveStrLength(String path) {
        if (path.length() == 0) {
            return 0;
        }
        return path.charAt(0) == '/' ? 1 : 0;
    }

    @Override
    public int compare(String s1, String s2) {
        return s1.compareTo(s2);
    }

    @Override
    public int compare(char c1, char c2) {
        return Character.compare(c1, c2);
    }

    @Override
    public boolean equals(String s1, String s2) {
        return Objects.equals(s1, s2);
    }

    @Override
    public int hash(String s2) {
        if (s2 == null) {
            return 0;
        }
        return s2.hashCode();
    }

    @Override
    public boolean startsWith(String path, String prefix) {
        return path.startsWith(prefix);
    }

    @Override
    public boolean endsWith(String path, String suffix) {
        return path.endsWith(suffix);
    }

    @Override
    public boolean isSeparator(char c) {
        return c == '/';
    }

    @Override
    public char additionalSeparator() {
        return '\u0000';
    }

    @Override
    public boolean isCaseSensitive() {
        return true;
    }
}

