/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.vfs;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.ForwardingListenableFuture;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import com.google.common.util.concurrent.Uninterruptibles;
import com.google.devtools.build.lib.profiler.Profiler;
import com.google.devtools.build.lib.profiler.ProfilerTask;
import com.google.devtools.build.lib.profiler.SilentCloseable;
import com.google.devtools.build.lib.vfs.Dirent;
import com.google.devtools.build.lib.vfs.FileStatus;
import com.google.devtools.build.lib.vfs.Path;
import com.google.devtools.build.lib.vfs.Symlinks;
import com.google.devtools.build.lib.vfs.SyscallCache;
import com.google.devtools.build.lib.vfs.UnixGlobPathDiscriminator;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

public final class UnixGlob {
    private static final UnixGlobPathDiscriminator DEFAULT_DISCRIMINATOR = new UnixGlobPathDiscriminator(){};

    private UnixGlob() {
    }

    private static List<Path> globInternal(Path base, Collection<String> patterns, UnixGlobPathDiscriminator pathDiscriminator, SyscallCache syscalls, Executor executor) throws IOException, InterruptedException, BadPattern {
        GlobVisitor visitor = new GlobVisitor(executor);
        return visitor.glob(base, patterns, pathDiscriminator, syscalls);
    }

    private static List<Path> globInternalUninterruptible(Path base, Collection<String> patterns, UnixGlobPathDiscriminator pathDiscriminator, SyscallCache syscalls, Executor executor) throws IOException, BadPattern {
        GlobVisitor visitor = new GlobVisitor(executor);
        return visitor.globUninterruptible(base, patterns, pathDiscriminator, syscalls);
    }

    private static long globInternalAndReturnNumGlobTasksForTesting(Path base, Collection<String> patterns, UnixGlobPathDiscriminator pathDiscriminator, SyscallCache syscalls, Executor executor) throws IOException, InterruptedException, BadPattern {
        GlobVisitor visitor = new GlobVisitor(executor);
        visitor.glob(base, patterns, pathDiscriminator, syscalls);
        return visitor.getNumGlobTasksForTesting();
    }

    private static Future<List<Path>> globAsyncInternal(Path base, Collection<String> patterns, UnixGlobPathDiscriminator pathDiscriminator, SyscallCache syscalls, Executor executor) throws BadPattern {
        Preconditions.checkNotNull(executor, "%s %s", (Object)base, patterns);
        return new GlobVisitor(executor).globAsync(base, patterns, pathDiscriminator, syscalls);
    }

    private static List<String[]> checkAndSplitPatterns(Collection<String> patterns) throws BadPattern {
        ArrayList<String[]> list = Lists.newArrayListWithCapacity(patterns.size());
        for (String pattern : patterns) {
            String error = UnixGlob.checkPatternForError(pattern);
            if (error != null) {
                throw new BadPattern(error + " (in glob pattern '" + pattern + "')");
            }
            Iterable<String> segments = Splitter.on('/').split(pattern);
            list.add(Iterables.toArray(segments, String.class));
        }
        return list;
    }

    @Nullable
    public static String checkPatternForError(String pattern) {
        if (pattern.isEmpty()) {
            return "pattern cannot be empty";
        }
        if (pattern.charAt(0) == '/') {
            return "pattern cannot be absolute";
        }
        Iterable<String> segments = Splitter.on('/').split(pattern);
        for (String segment : segments) {
            if (segment.isEmpty()) {
                return "empty segment not permitted";
            }
            if (segment.equals(".") || segment.equals("..")) {
                return "segment '" + segment + "' not permitted";
            }
            if (!segment.contains("**") || segment.equals("**")) continue;
            return "recursive wildcard must be its own segment";
        }
        return null;
    }

    public static boolean matches(String pattern, String str) {
        return UnixGlob.matches(pattern, str, null);
    }

    public static boolean matches(String pattern, String str, Map<String, Pattern> patternCache) {
        if (pattern.length() == 0 || str.length() == 0) {
            return false;
        }
        if (pattern.equals("**")) {
            return true;
        }
        if (pattern.equals("*")) {
            return true;
        }
        if (str.charAt(0) == '.' && pattern.charAt(0) != '.') {
            return false;
        }
        if (pattern.charAt(0) == '*' && pattern.lastIndexOf(42) == 0) {
            return str.endsWith(pattern.substring(1));
        }
        int lastIndex = pattern.length() - 1;
        if (pattern.charAt(lastIndex) == '*' && pattern.indexOf(42) == lastIndex) {
            return str.startsWith(pattern.substring(0, lastIndex));
        }
        Pattern regex = patternCache == null ? UnixGlob.makePatternFromWildcard(pattern) : patternCache.computeIfAbsent(pattern, p -> UnixGlob.makePatternFromWildcard(p));
        return regex.matcher(str).matches();
    }

    private static Pattern makePatternFromWildcard(String pattern) {
        StringBuilder regexp = new StringBuilder();
        int len = pattern.length();
        block6: for (int i = 0; i < len; ++i) {
            char c = pattern.charAt(i);
            switch (c) {
                case '*': {
                    int toIncrement = 0;
                    if (len > i + 1 && pattern.charAt(i + 1) == '*') {
                        toIncrement = 1;
                        if (len > i + 2 && pattern.charAt(i + 2) == '/') {
                            toIncrement = 2;
                        } else if (len == i + 2 && i > 0 && pattern.charAt(i - 1) == '/') {
                            regexp.delete(regexp.length() - 1, regexp.length());
                        }
                    }
                    regexp.append(".*");
                    i += toIncrement;
                    continue block6;
                }
                case '?': {
                    regexp.append('.');
                    continue block6;
                }
                case '$': 
                case '+': 
                case '.': 
                case '[': 
                case '\\': 
                case ']': 
                case '^': 
                case '{': 
                case '|': 
                case '}': {
                    regexp.append('\\');
                    regexp.append(c);
                    continue block6;
                }
                case '(': 
                case ')': {
                    continue block6;
                }
                default: {
                    regexp.append(c);
                }
            }
        }
        return Pattern.compile(regexp.toString());
    }

    public static void removeExcludes(Set<String> paths, Collection<String> excludes) throws BadPattern {
        ArrayList<String> complexPatterns = new ArrayList<String>(excludes.size());
        HashMap<String, List> starstarSlashStarHeadTailPairs = new HashMap<String, List>();
        for (String string : excludes) {
            if (UnixGlob.isWildcardFree(string)) {
                paths.remove(string);
                continue;
            }
            int patternPos = string.indexOf("**/*");
            if (patternPos != -1) {
                String head = string.substring(0, patternPos);
                String tail = string.substring(patternPos + 4);
                if (UnixGlob.isWildcardFree(head) && UnixGlob.isWildcardFree(tail)) {
                    starstarSlashStarHeadTailPairs.computeIfAbsent(head, h2 -> new ArrayList()).add(tail);
                    continue;
                }
            }
            complexPatterns.add(string);
        }
        for (Map.Entry entry : starstarSlashStarHeadTailPairs.entrySet()) {
            paths.removeIf(path -> {
                if (path.startsWith((String)headTailPair.getKey())) {
                    for (String tail : (List)headTailPair.getValue()) {
                        if (!path.endsWith(tail)) continue;
                        return true;
                    }
                }
                return false;
            });
        }
        if (complexPatterns.isEmpty()) {
            return;
        }
        List<String[]> splitPatterns = UnixGlob.checkAndSplitPatterns(complexPatterns);
        HashMap hashMap = new HashMap();
        paths.removeIf(path -> {
            String[] segments = Iterables.toArray(Splitter.on('/').split((CharSequence)path), String.class);
            for (String[] splitPattern : splitPatterns) {
                if (!UnixGlob.matchesPattern(splitPattern, segments, 0, 0, patternCache)) continue;
                return true;
            }
            return false;
        });
    }

    private static boolean matchesPattern(String[] pattern, String[] path, int i, int j, Map<String, Pattern> patternCache) {
        if (i == pattern.length) {
            return j == path.length;
        }
        if (pattern[i].equals("**")) {
            return UnixGlob.matchesPattern(pattern, path, i + 1, j, patternCache) || j < path.length && UnixGlob.matchesPattern(pattern, path, i, j + 1, patternCache);
        }
        if (j == path.length) {
            return false;
        }
        if (UnixGlob.matches(pattern[i], path[j], patternCache)) {
            return UnixGlob.matchesPattern(pattern, path, i + 1, j + 1, patternCache);
        }
        return false;
    }

    private static boolean isWildcardFree(String pattern) {
        return !pattern.contains("*") && !pattern.contains("?");
    }

    private static final class GlobVisitor {
        private final Collection<Path> results = Sets.newConcurrentHashSet();
        private final ConcurrentHashMap<String, Pattern> cache = new ConcurrentHashMap();
        private final GlobFuture result;
        private final Executor executor;
        private final AtomicLong totalOps = new AtomicLong(0L);
        private final AtomicLong pendingOps = new AtomicLong(0L);
        private final AtomicReference<IOException> ioException = new AtomicReference();
        private final AtomicReference<RuntimeException> runtimeException = new AtomicReference();
        private final AtomicReference<Error> error = new AtomicReference();
        private volatile boolean canceled = false;

        GlobVisitor(Executor executor) {
            this.executor = executor;
            this.result = new GlobFuture(this);
        }

        List<Path> glob(Path base, Collection<String> patterns, UnixGlobPathDiscriminator pathDiscriminator, SyscallCache syscalls) throws IOException, InterruptedException, BadPattern {
            try {
                return this.globAsync(base, patterns, pathDiscriminator, syscalls).get();
            }
            catch (ExecutionException e) {
                Throwable cause = e.getCause();
                Throwables.propagateIfPossible(cause, IOException.class);
                throw new RuntimeException(e);
            }
        }

        List<Path> globUninterruptible(Path base, Collection<String> patterns, UnixGlobPathDiscriminator pathDiscriminator, SyscallCache syscalls) throws IOException, BadPattern {
            try {
                return Uninterruptibles.getUninterruptibly(this.globAsync(base, patterns, pathDiscriminator, syscalls));
            }
            catch (ExecutionException e) {
                Throwable cause = e.getCause();
                Throwables.propagateIfPossible(cause, IOException.class);
                Throwables.propagateIfPossible(cause, BadPattern.class);
                throw new RuntimeException(e);
            }
        }

        private static boolean isRecursivePattern(String pattern) {
            return "**".equals(pattern);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Future<List<Path>> globAsync(Path base, Collection<String> patterns, UnixGlobPathDiscriminator pathDiscriminator, SyscallCache syscalls) throws BadPattern {
            FileStatus baseStat;
            try {
                baseStat = syscalls.statIfFound(base, Symlinks.FOLLOW);
            }
            catch (IOException e) {
                return Futures.immediateFailedFuture(e);
            }
            if (baseStat == null || patterns.isEmpty()) {
                return Futures.immediateFuture(Collections.emptyList());
            }
            List<String[]> splitPatterns = UnixGlob.checkAndSplitPatterns(patterns);
            this.pendingOps.incrementAndGet();
            try {
                for (String[] splitPattern : splitPatterns) {
                    int numRecursivePatterns = 0;
                    for (String pattern : splitPattern) {
                        if (!GlobVisitor.isRecursivePattern(pattern)) continue;
                        ++numRecursivePatterns;
                    }
                    GlobTaskContext context = numRecursivePatterns > 1 ? new RecursiveGlobTaskContext(splitPattern, pathDiscriminator, syscalls) : new GlobTaskContext(splitPattern, pathDiscriminator, syscalls);
                    context.queueGlob(base, baseStat.isDirectory(), 0);
                }
            }
            finally {
                this.decrementAndCheckDone();
            }
            return this.result;
        }

        @Nullable
        private Throwable getMostSeriousThrowableSoFar() {
            if (this.error.get() != null) {
                return this.error.get();
            }
            if (this.runtimeException.get() != null) {
                return this.runtimeException.get();
            }
            if (this.ioException.get() != null) {
                return this.ioException.get();
            }
            return null;
        }

        private void queueGlob(final Path base, final boolean baseIsDir, final int idx, final GlobTaskContext context) {
            this.enqueue(new Runnable(){

                @Override
                public void run() {
                    try (SilentCloseable c = Profiler.instance().profile(ProfilerTask.VFS_GLOB, base.getPathString());){
                        this.reallyGlob(base, baseIsDir, idx, context);
                    }
                    catch (IOException e) {
                        ioException.set(e);
                    }
                    catch (RuntimeException e) {
                        runtimeException.set(e);
                    }
                    catch (Error e) {
                        error.set(e);
                    }
                }

                public String toString() {
                    return String.format("%s glob(include=[%s])", base.getPathString(), "\"" + Joiner.on("\", \"").join(context.patternParts) + "\"");
                }
            });
        }

        private void queueTask(Runnable runnable) {
            this.enqueue(runnable);
        }

        void enqueue(Runnable r) {
            this.totalOps.incrementAndGet();
            this.pendingOps.incrementAndGet();
            Runnable wrapped = () -> {
                try {
                    if (!this.canceled && this.getMostSeriousThrowableSoFar() == null) {
                        r.run();
                    }
                }
                finally {
                    this.decrementAndCheckDone();
                }
            };
            if (this.executor == null) {
                wrapped.run();
            } else {
                this.executor.execute(wrapped);
            }
        }

        private long getNumGlobTasksForTesting() {
            return this.totalOps.get();
        }

        void cancel() {
            this.canceled = true;
        }

        private void decrementAndCheckDone() {
            if (this.pendingOps.decrementAndGet() == 0L) {
                Throwable mostSeriousThrowable = this.getMostSeriousThrowableSoFar();
                if (this.canceled) {
                    this.result.markCanceled();
                } else if (mostSeriousThrowable != null) {
                    this.result.setException(mostSeriousThrowable);
                } else {
                    this.result.set(ImmutableList.copyOf(this.results));
                }
            }
        }

        private void reallyGlob(Path base, boolean baseIsDir, int idx, GlobTaskContext context) throws IOException {
            if (baseIsDir && !context.pathDiscriminator.shouldTraverseDirectory(base)) {
                this.maybeAddResult(context, base, baseIsDir);
                return;
            }
            if (idx == context.patternParts.length) {
                this.maybeAddResult(context, base, baseIsDir);
                return;
            }
            if (!baseIsDir) {
                return;
            }
            String pattern = context.patternParts[idx];
            if (GlobVisitor.isRecursivePattern(pattern)) {
                context.queueGlob(base, baseIsDir, idx + 1);
            }
            if (!pattern.contains("*") && !pattern.contains("?")) {
                Path child = base.getChild(pattern);
                FileStatus status = context.syscalls.statIfFound(child, Symlinks.FOLLOW);
                if (status == null || !status.isDirectory() && !status.isFile()) {
                    return;
                }
                context.queueGlob(child, status.isDirectory(), idx + 1);
                return;
            }
            Collection<Dirent> dents = context.syscalls.readdir(base);
            for (Dirent dent : dents) {
                Dirent.Type childType = dent.getType();
                if (childType == Dirent.Type.UNKNOWN || !UnixGlob.matches(pattern, dent.getName(), this.cache)) continue;
                Path child = base.getChild(dent.getName());
                if (childType == Dirent.Type.SYMLINK) {
                    this.processSymlink(child, idx, context);
                    continue;
                }
                this.processFileOrDirectory(child, childType == Dirent.Type.DIRECTORY, idx, context);
            }
        }

        private void maybeAddResult(GlobTaskContext context, Path base, boolean isDirectory) {
            if (context.pathDiscriminator.shouldIncludePathInResult(base, isDirectory)) {
                this.results.add(base);
            }
        }

        private void processSymlink(Path path, int idx, GlobTaskContext context) {
            context.queueTask(() -> {
                try {
                    FileStatus status = context.syscalls.statIfFound(path, Symlinks.FOLLOW);
                    if (status != null) {
                        this.processFileOrDirectory(path, status.isDirectory(), idx, context);
                    }
                }
                catch (IOException e) {
                    this.ioException.compareAndSet(null, e);
                }
            });
        }

        private void processFileOrDirectory(Path path, boolean isDir, int idx, GlobTaskContext context) {
            boolean isRecursivePattern = GlobVisitor.isRecursivePattern(context.patternParts[idx]);
            if (isDir) {
                context.queueGlob(path, true, idx + (isRecursivePattern ? 0 : 1));
            } else if (idx + 1 == context.patternParts.length) {
                this.maybeAddResult(context, path, false);
            }
        }

        private class RecursiveGlobTaskContext
        extends GlobTaskContext {
            private final Set<GlobTask> visitedGlobSubTasks;

            private RecursiveGlobTaskContext(String[] patternParts, UnixGlobPathDiscriminator pathDiscriminator, SyscallCache syscalls) {
                super(patternParts, pathDiscriminator, syscalls);
                this.visitedGlobSubTasks = Sets.newConcurrentHashSet();
            }

            @Override
            protected void queueGlob(Path base, boolean baseIsDir, int patternIdx) {
                if (this.visitedGlobSubTasks.add(new GlobTask(base, patternIdx))) {
                    super.queueGlob(base, baseIsDir, patternIdx);
                }
            }

            private class GlobTask {
                private final Path base;
                private final int patternIdx;

                private GlobTask(Path base, int patternIdx) {
                    this.base = base;
                    this.patternIdx = patternIdx;
                }

                public boolean equals(Object obj) {
                    if (!(obj instanceof GlobTask)) {
                        return false;
                    }
                    GlobTask other = (GlobTask)obj;
                    return this.base.equals(other.base) && this.patternIdx == other.patternIdx;
                }

                public int hashCode() {
                    return Objects.hash(this.base, this.patternIdx);
                }
            }
        }

        private class GlobTaskContext {
            private final String[] patternParts;
            private final UnixGlobPathDiscriminator pathDiscriminator;
            private final SyscallCache syscalls;

            GlobTaskContext(String[] patternParts, UnixGlobPathDiscriminator pathDiscriminator, SyscallCache syscalls) {
                this.patternParts = patternParts;
                this.pathDiscriminator = pathDiscriminator;
                this.syscalls = syscalls;
            }

            protected void queueGlob(Path base, boolean baseIsDir, int patternIdx) {
                GlobVisitor.this.queueGlob(base, baseIsDir, patternIdx, this);
            }

            protected void queueTask(Runnable runnable) {
                GlobVisitor.this.queueTask(runnable);
            }
        }
    }

    private static class GlobFuture
    extends ForwardingListenableFuture<List<Path>> {
        private final GlobVisitor visitor;
        private final SettableFuture<List<Path>> delegate = SettableFuture.create();

        public GlobFuture(GlobVisitor visitor) {
            this.visitor = visitor;
        }

        @Override
        protected ListenableFuture<List<Path>> delegate() {
            return this.delegate;
        }

        public void setException(Throwable throwable) {
            this.delegate.setException(throwable);
        }

        public void set(List<Path> paths) {
            this.delegate.set(paths);
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            this.visitor.cancel();
            return true;
        }

        public void markCanceled() {
            super.cancel(true);
        }
    }

    public static class Builder {
        private final Path base;
        private final List<String> patterns;
        private final SyscallCache syscallCache;
        private UnixGlobPathDiscriminator pathDiscriminator = DEFAULT_DISCRIMINATOR;
        private Executor executor;

        public Builder(Path base, SyscallCache syscallCache) {
            this.base = base;
            this.syscallCache = syscallCache;
            this.patterns = Lists.newArrayList();
        }

        @CanIgnoreReturnValue
        public Builder addPattern(String pattern) {
            this.patterns.add(pattern);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addPatterns(String ... patterns) {
            Collections.addAll(this.patterns, patterns);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addPatterns(Collection<String> patterns) {
            this.patterns.addAll(patterns);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setExecutor(Executor pool) {
            this.executor = pool;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setPathDiscriminator(UnixGlobPathDiscriminator pathDiscriminator) {
            this.pathDiscriminator = pathDiscriminator;
            return this;
        }

        public List<Path> glob() throws IOException, BadPattern {
            return UnixGlob.globInternalUninterruptible(this.base, this.patterns, this.pathDiscriminator, this.syscallCache, this.executor);
        }

        public List<Path> globInterruptible() throws IOException, InterruptedException, BadPattern {
            return UnixGlob.globInternal(this.base, this.patterns, this.pathDiscriminator, this.syscallCache, this.executor);
        }

        @VisibleForTesting
        public long globInterruptibleAndReturnNumGlobTasksForTesting() throws IOException, InterruptedException, BadPattern {
            return UnixGlob.globInternalAndReturnNumGlobTasksForTesting(this.base, this.patterns, this.pathDiscriminator, this.syscallCache, this.executor);
        }

        public Future<List<Path>> globAsync() throws BadPattern {
            return UnixGlob.globAsyncInternal(this.base, this.patterns, this.pathDiscriminator, this.syscallCache, this.executor);
        }
    }

    public static final class BadPattern
    extends Exception {
        private BadPattern(String message) {
            super(message);
        }
    }
}

