/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.vfs;

import com.google.common.base.Preconditions;
import com.google.devtools.build.lib.vfs.Dirent;
import com.google.devtools.build.lib.vfs.FileStatus;
import com.google.devtools.build.lib.vfs.Path;
import com.google.devtools.build.lib.vfs.Symlinks;
import com.google.devtools.build.lib.vfs.XattrProvider;
import java.io.IOException;
import java.util.Collection;
import javax.annotation.Nullable;

public interface SyscallCache
extends XattrProvider {
    public static final SyscallCache NO_CACHE = new SyscallCache(){

        @Override
        public Collection<Dirent> readdir(Path path) throws IOException {
            return path.readdir(Symlinks.NOFOLLOW);
        }

        @Override
        @Nullable
        public FileStatus statIfFound(Path path, Symlinks symlinks) throws IOException {
            return path.statIfFound(symlinks);
        }

        @Override
        public DirentTypeWithSkip getType(Path path, Symlinks symlinks) {
            return DirentTypeWithSkip.FILESYSTEM_OP_SKIPPED;
        }

        @Override
        public void clear() {
        }
    };

    public Collection<Dirent> readdir(Path var1) throws IOException;

    @Nullable
    public FileStatus statIfFound(Path var1, Symlinks var2) throws IOException;

    @Nullable
    public DirentTypeWithSkip getType(Path var1, Symlinks var2) throws IOException;

    public void clear();

    default public void noteAnalysisPhaseEnded() {
        this.clear();
    }

    @Nullable
    public static Dirent.Type statusToDirentType(FileStatus status) {
        if (status == null) {
            return null;
        }
        if (status.isFile()) {
            return Dirent.Type.FILE;
        }
        if (status.isDirectory()) {
            return Dirent.Type.DIRECTORY;
        }
        if (status.isSymbolicLink()) {
            return Dirent.Type.SYMLINK;
        }
        return Dirent.Type.UNKNOWN;
    }

    public static enum DirentTypeWithSkip {
        FILE(Dirent.Type.FILE),
        DIRECTORY(Dirent.Type.DIRECTORY),
        SYMLINK(Dirent.Type.SYMLINK),
        UNKNOWN(Dirent.Type.UNKNOWN),
        FILESYSTEM_OP_SKIPPED(null);

        @Nullable
        private final Dirent.Type type;

        private DirentTypeWithSkip(Dirent.Type type) {
            this.type = type;
        }

        public Dirent.Type getType() {
            Preconditions.checkState(this != FILESYSTEM_OP_SKIPPED, "No type if filesystem op skipped");
            return this.type;
        }

        @Nullable
        public static DirentTypeWithSkip of(@Nullable Dirent.Type type) {
            if (type == null) {
                return null;
            }
            switch (type) {
                case FILE: {
                    return FILE;
                }
                case DIRECTORY: {
                    return DIRECTORY;
                }
                case SYMLINK: {
                    return SYMLINK;
                }
                case UNKNOWN: {
                    return UNKNOWN;
                }
            }
            throw new IllegalStateException("Got unrecognized type " + type);
        }
    }
}

