/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.vfs;

import com.google.common.base.Splitter;
import com.google.devtools.build.lib.vfs.FileSystem;
import com.google.devtools.build.lib.vfs.Path;
import com.google.devtools.build.lib.vfs.PathFragment;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;

public class SearchPath {
    private static final Splitter SEPARATOR = Splitter.on(':');

    public static List<Path> parse(FileSystem fs, @Nullable String searchPath) {
        ArrayList<Path> paths = new ArrayList<Path>();
        if (searchPath == null) {
            return paths;
        }
        for (String p : SEPARATOR.split(searchPath)) {
            PathFragment pf = PathFragment.create(p);
            if (!pf.isAbsolute()) continue;
            paths.add(fs.getPath(pf));
        }
        return paths;
    }

    @Nullable
    public static Path which(List<Path> searchPath, String exe) {
        PathFragment fragment = PathFragment.create(exe);
        if (fragment.isAbsolute() || !fragment.isSingleSegment()) {
            return null;
        }
        for (Path p : searchPath) {
            Path ch = p.getChild(exe);
            try {
                if (!ch.exists() || !ch.isExecutable()) continue;
                return ch;
            }
            catch (IOException iOException) {
            }
        }
        return null;
    }
}

