/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.vfs;

import com.google.common.base.Preconditions;
import com.google.devtools.build.lib.skyframe.serialization.autocodec.AutoCodec;
import com.google.devtools.build.lib.vfs.FileStateKey;
import com.google.devtools.build.lib.vfs.OsPathPolicy;
import com.google.devtools.build.lib.vfs.Path;
import com.google.devtools.build.lib.vfs.PathFragment;
import com.google.devtools.build.lib.vfs.Root;
import com.google.devtools.build.skyframe.SkyKey;
import java.util.Comparator;
import javax.annotation.Nullable;

@AutoCodec
public final class RootedPath
implements Comparable<RootedPath>,
FileStateKey {
    @Nullable
    private static final SkyKey.SkyKeyInterner<RootedPath> interner = OsPathPolicy.getFilePathOs().isCaseSensitive() ? SkyKey.newInterner() : null;
    private final Root root;
    private final PathFragment rootRelativePath;
    private final transient int hashCode;
    private static final Comparator<RootedPath> COMPARATOR = Comparator.comparing(RootedPath::getRoot).thenComparing(RootedPath::getRootRelativePath);

    @AutoCodec.Instantiator
    @AutoCodec.VisibleForSerialization
    static RootedPath createInternal(Root root, PathFragment rootRelativePath) {
        Preconditions.checkArgument(rootRelativePath.isAbsolute() == root.isAbsolute(), "rootRelativePath: %s root: %s", (Object)rootRelativePath, (Object)root);
        RootedPath rootedPath = new RootedPath(root, rootRelativePath);
        return interner != null ? interner.intern(rootedPath) : rootedPath;
    }

    private RootedPath(Root root, PathFragment rootRelativePath) {
        this.root = root;
        this.rootRelativePath = rootRelativePath;
        this.hashCode = 31 * root.hashCode() + rootRelativePath.hashCode();
    }

    public static RootedPath toRootedPath(Root root, PathFragment rootRelativePath) {
        if (rootRelativePath.isAbsolute() && !root.isAbsolute()) {
            Preconditions.checkArgument(root.contains(rootRelativePath), "rootRelativePath '%s' is absolute, but it's not under root '%s'", (Object)rootRelativePath, (Object)root);
            rootRelativePath = root.relativize(rootRelativePath);
        }
        return RootedPath.createInternal(root, rootRelativePath);
    }

    public static RootedPath toRootedPath(Root root, Path path) {
        Preconditions.checkArgument(root.contains(path), "path: %s root: %s", (Object)path, (Object)root);
        return RootedPath.toRootedPath(root, path.asFragment());
    }

    public static RootedPath toRootedPathMaybeUnderRoot(Path path, Iterable<Root> packagePathRoots) {
        for (Root root : packagePathRoots) {
            if (!root.contains(path)) continue;
            return RootedPath.toRootedPath(root, path);
        }
        return RootedPath.toRootedPath(Root.absoluteRoot(path.getFileSystem()), path);
    }

    public Path asPath() {
        return this.root.getRelative(this.rootRelativePath);
    }

    public Root getRoot() {
        return this.root;
    }

    public PathFragment getRootRelativePath() {
        return this.rootRelativePath;
    }

    @Nullable
    public RootedPath getParentDirectory() {
        PathFragment rootRelativeParentDirectory = this.rootRelativePath.getParentDirectory();
        if (rootRelativeParentDirectory == null) {
            return null;
        }
        return RootedPath.createInternal(this.root, rootRelativeParentDirectory);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof RootedPath)) {
            return false;
        }
        RootedPath other = (RootedPath)obj;
        return this.hashCode == other.hashCode && this.root.equals(other.root) && this.rootRelativePath.equals(other.rootRelativePath);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        return "[" + this.root + "]/[" + this.rootRelativePath + "]";
    }

    @Override
    public int compareTo(RootedPath o) {
        return COMPARATOR.compare(this, o);
    }

    @Override
    public RootedPath argument() {
        return this;
    }

    @Override
    @Nullable
    public SkyKey.SkyKeyInterner<?> getSkyKeyInterner() {
        return interner;
    }
}

