/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.vfs;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.devtools.build.lib.skyframe.serialization.DeserializationContext;
import com.google.devtools.build.lib.skyframe.serialization.ObjectCodec;
import com.google.devtools.build.lib.skyframe.serialization.SerializationContext;
import com.google.devtools.build.lib.skyframe.serialization.SerializationException;
import com.google.devtools.build.lib.vfs.FileSystem;
import com.google.devtools.build.lib.vfs.Path;
import com.google.devtools.build.lib.vfs.PathFragment;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import java.io.IOException;
import javax.annotation.Nullable;

public abstract class Root
implements Comparable<Root> {
    public static Root fromPath(Path path) {
        return new PathRoot(path);
    }

    public static Root absoluteRoot(FileSystem fileSystem) {
        return fileSystem.getAbsoluteRoot();
    }

    public static Root toFileSystem(Root root, FileSystem fileSystem) {
        return root.isAbsolute() ? new AbsoluteRoot(fileSystem) : new PathRoot(fileSystem.getPath(root.asPath().asFragment()));
    }

    public abstract Path getRelative(PathFragment var1);

    public abstract Path getRelative(String var1);

    public abstract PathFragment relativize(Path var1);

    public abstract PathFragment relativize(PathFragment var1);

    public abstract boolean contains(Path var1);

    public abstract boolean contains(PathFragment var1);

    @Nullable
    public abstract Path asPath();

    public abstract FileSystem getFileSystem();

    public abstract boolean isAbsolute();

    private static class RootCodec
    implements ObjectCodec<Root> {
        private RootCodec() {
        }

        @Override
        public Class<? extends Root> getEncodedClass() {
            return Root.class;
        }

        @Override
        public void serialize(SerializationContext context, Root root, CodedOutputStream codedOut) throws SerializationException, IOException {
            RootCodecDependencies codecDeps = context.getDependency(RootCodecDependencies.class);
            for (int i = 0; i < codecDeps.likelyPopularRoots.size(); ++i) {
                Root likely = (Root)codecDeps.likelyPopularRoots.get(i);
                if (!root.equals(likely)) continue;
                codedOut.write((byte)(i + 1));
                return;
            }
            codedOut.writeBoolNoTag(false);
            if (root instanceof PathRoot) {
                codedOut.writeBoolNoTag(true);
                PathRoot pathRoot = (PathRoot)root;
                context.serialize(pathRoot.path, codedOut);
            } else if (root instanceof AbsoluteRoot) {
                codedOut.writeBoolNoTag(false);
                AbsoluteRoot absoluteRoot = (AbsoluteRoot)root;
                context.serialize(absoluteRoot.fileSystem, codedOut);
            } else {
                throw new IllegalStateException("Unexpected Root: " + root);
            }
        }

        @Override
        public Root deserialize(DeserializationContext context, CodedInputStream codedIn) throws SerializationException, IOException {
            byte likelyIndicator = codedIn.readRawByte();
            if (likelyIndicator != 0) {
                RootCodecDependencies codecDeps = context.getDependency(RootCodecDependencies.class);
                return (Root)codecDeps.likelyPopularRoots.get(likelyIndicator - 1);
            }
            if (codedIn.readBool()) {
                Path path = (Path)context.deserialize(codedIn);
                return new PathRoot(path);
            }
            FileSystem fileSystem = (FileSystem)context.deserialize(codedIn);
            return new AbsoluteRoot(fileSystem);
        }
    }

    public static class RootCodecDependencies {
        private final ImmutableList<Root> likelyPopularRoots;

        public RootCodecDependencies() {
            this(ImmutableList.of());
        }

        public RootCodecDependencies(Root likelyPopularRoot) {
            this(ImmutableList.of(likelyPopularRoot));
        }

        public RootCodecDependencies(Iterable<Root> likelyPopularRoots) {
            this.likelyPopularRoots = ImmutableList.copyOf(likelyPopularRoots);
            Preconditions.checkArgument(this.likelyPopularRoots.size() < 256);
        }
    }

    public static final class AbsoluteRoot
    extends Root {
        private final FileSystem fileSystem;

        AbsoluteRoot(FileSystem fileSystem) {
            this.fileSystem = Preconditions.checkNotNull(fileSystem);
        }

        @Override
        public Path getRelative(PathFragment rootRelativePath) {
            Preconditions.checkArgument(rootRelativePath.isAbsolute());
            return this.fileSystem.getPath(rootRelativePath);
        }

        @Override
        public Path getRelative(String rootRelativePath) {
            return this.getRelative(PathFragment.create(rootRelativePath));
        }

        @Override
        public PathFragment relativize(Path path) {
            return path.asFragment();
        }

        @Override
        public PathFragment relativize(PathFragment absolutePathFragment) {
            Preconditions.checkArgument(absolutePathFragment.isAbsolute());
            return absolutePathFragment;
        }

        @Override
        public boolean contains(Path path) {
            return true;
        }

        @Override
        public boolean contains(PathFragment absolutePathFragment) {
            return absolutePathFragment.isAbsolute();
        }

        @Override
        public boolean isAbsolute() {
            return true;
        }

        @Override
        @Nullable
        public Path asPath() {
            return null;
        }

        @Override
        public FileSystem getFileSystem() {
            return this.fileSystem;
        }

        public String toString() {
            return "<absolute root>";
        }

        @Override
        public int compareTo(Root o) {
            if (o instanceof AbsoluteRoot) {
                return Integer.compare(this.hashCode(), o.hashCode());
            }
            if (o instanceof PathRoot) {
                return -1;
            }
            throw new AssertionError((Object)("Unknown Root subclass: " + o.getClass().getName()));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof AbsoluteRoot)) {
                return false;
            }
            AbsoluteRoot that = (AbsoluteRoot)o;
            return this.fileSystem.equals(that.fileSystem);
        }

        public int hashCode() {
            return 31 + this.fileSystem.hashCode();
        }
    }

    public static final class PathRoot
    extends Root {
        private final Path path;

        private PathRoot(Path path) {
            this.path = path;
        }

        @Override
        public Path getRelative(PathFragment rootRelativePath) {
            return this.path.getRelative(rootRelativePath);
        }

        @Override
        public Path getRelative(String rootRelativePath) {
            return this.path.getRelative(rootRelativePath);
        }

        @Override
        public PathFragment relativize(Path path) {
            return path.relativeTo(this.path);
        }

        @Override
        public PathFragment relativize(PathFragment absolutePathFragment) {
            Preconditions.checkArgument(absolutePathFragment.isAbsolute());
            return absolutePathFragment.relativeTo(this.path.asFragment());
        }

        @Override
        public boolean contains(Path path) {
            return path.startsWith(this.path);
        }

        @Override
        public boolean contains(PathFragment absolutePathFragment) {
            return absolutePathFragment.isAbsolute() && absolutePathFragment.startsWith(this.path.asFragment());
        }

        @Override
        public Path asPath() {
            return this.path;
        }

        @Override
        public FileSystem getFileSystem() {
            return this.path.getFileSystem();
        }

        @Override
        public boolean isAbsolute() {
            return false;
        }

        public String toString() {
            return this.path.toString();
        }

        @Override
        public int compareTo(Root o) {
            if (o instanceof AbsoluteRoot) {
                return 1;
            }
            if (o instanceof PathRoot) {
                return this.path.compareTo(((PathRoot)o).path);
            }
            throw new AssertionError((Object)("Unknown Root subclass: " + o.getClass().getName()));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PathRoot pathRoot = (PathRoot)o;
            return this.path.equals(pathRoot.path);
        }

        public int hashCode() {
            return this.path.hashCode();
        }
    }
}

