/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.vfs;

import com.google.devtools.build.lib.vfs.AbstractFileSystemWithCustomStat;
import com.google.devtools.build.lib.vfs.DigestHashFunction;
import com.google.devtools.build.lib.vfs.PathFragment;
import java.io.IOException;
import java.io.OutputStream;

public abstract class ReadonlyFileSystemWithCustomStat
extends AbstractFileSystemWithCustomStat {
    public ReadonlyFileSystemWithCustomStat(DigestHashFunction hashFunction) {
        super(hashFunction);
    }

    protected IOException modificationException() {
        String longname = this.getClass().getName();
        String shortname = longname.substring(longname.lastIndexOf(46) + 1);
        return new IOException(shortname + " does not support mutating operations");
    }

    @Override
    protected OutputStream getOutputStream(PathFragment path, boolean append) throws IOException {
        throw this.modificationException();
    }

    @Override
    protected void setReadable(PathFragment path, boolean readable) throws IOException {
        throw this.modificationException();
    }

    @Override
    public void setWritable(PathFragment path, boolean writable) throws IOException {
        throw this.modificationException();
    }

    @Override
    protected void setExecutable(PathFragment path, boolean executable) {
        throw new UnsupportedOperationException("setExecutable");
    }

    @Override
    public boolean supportsModifications(PathFragment path) {
        return false;
    }

    @Override
    public boolean supportsSymbolicLinksNatively(PathFragment path) {
        return false;
    }

    @Override
    public boolean supportsHardLinksNatively(PathFragment path) {
        return false;
    }

    @Override
    public boolean isFilePathCaseSensitive() {
        return true;
    }

    @Override
    public boolean createDirectory(PathFragment path) throws IOException {
        throw this.modificationException();
    }

    @Override
    public void createDirectoryAndParents(PathFragment path) throws IOException {
        throw this.modificationException();
    }

    @Override
    protected void createSymbolicLink(PathFragment linkPath, PathFragment targetFragment) throws IOException {
        throw this.modificationException();
    }

    @Override
    protected void createFSDependentHardLink(PathFragment linkPath, PathFragment originalPath) throws IOException {
        throw this.modificationException();
    }

    @Override
    public void renameTo(PathFragment sourcePath, PathFragment targetPath) throws IOException {
        throw this.modificationException();
    }

    @Override
    protected boolean delete(PathFragment path) throws IOException {
        throw this.modificationException();
    }

    @Override
    public void setLastModifiedTime(PathFragment path, long newTime) throws IOException {
        throw this.modificationException();
    }
}

