/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.vfs;

import com.google.devtools.build.lib.skyframe.serialization.DeserializationContext;
import com.google.devtools.build.lib.skyframe.serialization.ObjectCodec;
import com.google.devtools.build.lib.skyframe.serialization.SerializationContext;
import com.google.devtools.build.lib.skyframe.serialization.SerializationException;
import com.google.devtools.build.lib.unsafe.UnsafeProvider;
import com.google.devtools.build.lib.vfs.FileSystem;
import com.google.devtools.build.lib.vfs.Path;
import com.google.devtools.build.lib.vfs.PathFragment;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import java.io.IOException;

class Path_AutoCodec
implements ObjectCodec<Path> {
    private final long pathFragment_offset;
    private final long fileSystem_offset;

    Path_AutoCodec() {
        try {
            this.pathFragment_offset = UnsafeProvider.unsafe().objectFieldOffset(Path.class.getDeclaredField("pathFragment"));
        }
        catch (NoSuchFieldException e) {
            throw new IllegalStateException(e);
        }
        try {
            this.fileSystem_offset = UnsafeProvider.unsafe().objectFieldOffset(Path.class.getDeclaredField("fileSystem"));
        }
        catch (NoSuchFieldException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public void serialize(SerializationContext context, Path input, CodedOutputStream codedOut) throws SerializationException, IOException {
        PathFragment unsafe_pathFragment = (PathFragment)UnsafeProvider.unsafe().getObject(input, this.pathFragment_offset);
        context.serialize(unsafe_pathFragment, codedOut);
        FileSystem unsafe_fileSystem = (FileSystem)UnsafeProvider.unsafe().getObject(input, this.fileSystem_offset);
        context.serialize(unsafe_fileSystem, codedOut);
    }

    @Override
    public Path deserialize(DeserializationContext context, CodedInputStream codedIn) throws SerializationException, IOException {
        PathFragment pathFragment_ = (PathFragment)context.deserialize(codedIn);
        FileSystem fileSystem_ = (FileSystem)context.deserialize(codedIn);
        return Path.create(pathFragment_, fileSystem_);
    }

    @Override
    public Class<Path> getEncodedClass() {
        return Path.class;
    }
}

