/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.vfs;

import com.google.common.base.Preconditions;
import com.google.devtools.build.lib.vfs.Dirent;
import com.google.devtools.build.lib.vfs.FileStatus;
import com.google.devtools.build.lib.vfs.FileSystem;
import com.google.devtools.build.lib.vfs.Path;
import com.google.devtools.build.lib.vfs.PathFragment;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SeekableByteChannel;
import java.util.Collection;

public abstract class PathTransformingDelegateFileSystem
extends FileSystem {
    protected final FileSystem delegateFs;

    public PathTransformingDelegateFileSystem(FileSystem delegateFs) {
        super(Preconditions.checkNotNull(delegateFs, "delegateFs").getDigestFunction());
        this.delegateFs = delegateFs;
    }

    @Override
    public boolean supportsModifications(PathFragment path) {
        return this.delegateFs.supportsModifications(this.toDelegatePath(path));
    }

    @Override
    public boolean supportsSymbolicLinksNatively(PathFragment path) {
        return this.delegateFs.supportsSymbolicLinksNatively(this.toDelegatePath(path));
    }

    @Override
    protected boolean supportsHardLinksNatively(PathFragment path) {
        return this.delegateFs.supportsHardLinksNatively(this.toDelegatePath(path));
    }

    @Override
    public boolean isFilePathCaseSensitive() {
        return this.delegateFs.isFilePathCaseSensitive();
    }

    @Override
    public boolean createDirectory(PathFragment path) throws IOException {
        return this.delegateFs.createDirectory(this.toDelegatePath(path));
    }

    @Override
    protected boolean createWritableDirectory(PathFragment path) throws IOException {
        return this.delegateFs.createWritableDirectory(this.toDelegatePath(path));
    }

    @Override
    public void createDirectoryAndParents(PathFragment path) throws IOException {
        this.delegateFs.createDirectoryAndParents(this.toDelegatePath(path));
    }

    @Override
    protected long getFileSize(PathFragment path, boolean followSymlinks) throws IOException {
        return this.delegateFs.getFileSize(this.toDelegatePath(path), followSymlinks);
    }

    @Override
    protected boolean delete(PathFragment path) throws IOException {
        return this.delegateFs.delete(this.toDelegatePath(path));
    }

    @Override
    protected long getLastModifiedTime(PathFragment path, boolean followSymlinks) throws IOException {
        return this.delegateFs.getLastModifiedTime(this.toDelegatePath(path), followSymlinks);
    }

    @Override
    public void setLastModifiedTime(PathFragment path, long newTime) throws IOException {
        this.delegateFs.setLastModifiedTime(this.toDelegatePath(path), newTime);
    }

    @Override
    protected boolean isSymbolicLink(PathFragment path) {
        return this.delegateFs.isSymbolicLink(this.toDelegatePath(path));
    }

    @Override
    protected boolean isDirectory(PathFragment path, boolean followSymlinks) {
        return this.delegateFs.isDirectory(this.toDelegatePath(path), followSymlinks);
    }

    @Override
    protected boolean isFile(PathFragment path, boolean followSymlinks) {
        return this.delegateFs.isFile(this.toDelegatePath(path), followSymlinks);
    }

    @Override
    protected boolean isSpecialFile(PathFragment path, boolean followSymlinks) {
        return this.delegateFs.isSpecialFile(this.toDelegatePath(path), followSymlinks);
    }

    @Override
    protected void createSymbolicLink(PathFragment linkPath, PathFragment targetFragment) throws IOException {
        this.delegateFs.createSymbolicLink(this.toDelegatePath(linkPath), targetFragment);
    }

    @Override
    protected PathFragment readSymbolicLink(PathFragment path) throws IOException {
        return this.fromDelegatePath(this.delegateFs.readSymbolicLink(this.toDelegatePath(path)));
    }

    @Override
    protected boolean exists(PathFragment path, boolean followSymlinks) {
        return this.delegateFs.exists(this.toDelegatePath(path), followSymlinks);
    }

    @Override
    public boolean exists(PathFragment path) {
        return this.delegateFs.exists(this.toDelegatePath(path));
    }

    @Override
    protected Collection<String> getDirectoryEntries(PathFragment path) throws IOException {
        return this.delegateFs.getDirectoryEntries(this.toDelegatePath(path));
    }

    @Override
    protected boolean isReadable(PathFragment path) throws IOException {
        return this.delegateFs.isReadable(this.toDelegatePath(path));
    }

    @Override
    protected void setReadable(PathFragment path, boolean readable) throws IOException {
        this.delegateFs.setReadable(this.toDelegatePath(path), readable);
    }

    @Override
    protected boolean isWritable(PathFragment path) throws IOException {
        return this.delegateFs.isWritable(this.toDelegatePath(path));
    }

    @Override
    public void setWritable(PathFragment path, boolean writable) throws IOException {
        this.delegateFs.setWritable(this.toDelegatePath(path), writable);
    }

    @Override
    protected boolean isExecutable(PathFragment path) throws IOException {
        return this.delegateFs.isExecutable(this.toDelegatePath(path));
    }

    @Override
    protected void setExecutable(PathFragment path, boolean executable) throws IOException {
        this.delegateFs.setExecutable(this.toDelegatePath(path), executable);
    }

    @Override
    protected InputStream getInputStream(PathFragment path) throws IOException {
        return this.delegateFs.getInputStream(this.toDelegatePath(path));
    }

    @Override
    protected ReadableByteChannel createReadableByteChannel(PathFragment path) throws IOException {
        return this.delegateFs.createReadableByteChannel(this.toDelegatePath(path));
    }

    @Override
    protected SeekableByteChannel createReadWriteByteChannel(PathFragment path) throws IOException {
        return this.delegateFs.createReadWriteByteChannel(this.toDelegatePath(path));
    }

    @Override
    protected OutputStream getOutputStream(PathFragment path, boolean append) throws IOException {
        return this.delegateFs.getOutputStream(this.toDelegatePath(path), append);
    }

    @Override
    protected OutputStream getOutputStream(PathFragment path, boolean append, boolean internal) throws IOException {
        return this.delegateFs.getOutputStream(this.toDelegatePath(path), append, internal);
    }

    @Override
    public void renameTo(PathFragment sourcePath, PathFragment targetPath) throws IOException {
        this.delegateFs.renameTo(this.toDelegatePath(sourcePath), this.toDelegatePath(targetPath));
    }

    @Override
    protected void createFSDependentHardLink(PathFragment linkPath, PathFragment originalPath) throws IOException {
        this.delegateFs.createFSDependentHardLink(this.toDelegatePath(linkPath), this.toDelegatePath(originalPath));
    }

    @Override
    public String getFileSystemType(PathFragment path) {
        return this.delegateFs.getFileSystemType(this.toDelegatePath(path));
    }

    @Override
    protected void deleteTree(PathFragment path) throws IOException {
        this.delegateFs.deleteTree(this.toDelegatePath(path));
    }

    @Override
    protected void deleteTreesBelow(PathFragment dir) throws IOException {
        this.delegateFs.deleteTreesBelow(this.toDelegatePath(dir));
    }

    @Override
    public byte[] getxattr(PathFragment path, String name, boolean followSymlinks) throws IOException {
        return this.delegateFs.getxattr(this.toDelegatePath(path), name, followSymlinks);
    }

    @Override
    protected byte[] getFastDigest(PathFragment path) throws IOException {
        return this.delegateFs.getFastDigest(this.toDelegatePath(path));
    }

    @Override
    protected byte[] getDigest(PathFragment path) throws IOException {
        return this.delegateFs.getDigest(this.toDelegatePath(path));
    }

    @Override
    protected PathFragment resolveOneLink(PathFragment path) throws IOException {
        return this.delegateFs.resolveOneLink(this.toDelegatePath(path));
    }

    @Override
    protected Path resolveSymbolicLinks(PathFragment path) throws IOException {
        return this.getPath(this.fromDelegatePath(this.delegateFs.resolveSymbolicLinks(this.toDelegatePath(path)).asFragment()));
    }

    @Override
    protected FileStatus stat(PathFragment path, boolean followSymlinks) throws IOException {
        return this.delegateFs.stat(this.toDelegatePath(path), followSymlinks);
    }

    @Override
    protected FileStatus statNullable(PathFragment path, boolean followSymlinks) {
        return this.delegateFs.statNullable(this.toDelegatePath(path), followSymlinks);
    }

    @Override
    protected FileStatus statIfFound(PathFragment path, boolean followSymlinks) throws IOException {
        return this.delegateFs.statIfFound(this.toDelegatePath(path), followSymlinks);
    }

    @Override
    protected PathFragment readSymbolicLinkUnchecked(PathFragment path) throws IOException {
        return this.delegateFs.readSymbolicLinkUnchecked(this.toDelegatePath(path));
    }

    @Override
    protected Collection<Dirent> readdir(PathFragment path, boolean followSymlinks) throws IOException {
        return this.delegateFs.readdir(this.toDelegatePath(path), followSymlinks);
    }

    @Override
    protected void chmod(PathFragment path, int mode) throws IOException {
        this.delegateFs.chmod(this.toDelegatePath(path), mode);
    }

    @Override
    protected void createHardLink(PathFragment linkPath, PathFragment originalPath) throws IOException {
        this.delegateFs.createHardLink(this.toDelegatePath(linkPath), this.toDelegatePath(originalPath));
    }

    @Override
    protected void prefetchPackageAsync(PathFragment path, int maxDirs) {
        this.delegateFs.prefetchPackageAsync(this.toDelegatePath(path), maxDirs);
    }

    protected abstract PathFragment toDelegatePath(PathFragment var1);

    protected abstract PathFragment fromDelegatePath(PathFragment var1);
}

