/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.vfs;

import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;

final class PathSegmentIterator
implements Iterator<String> {
    private final String normalizedPath;
    private int start;

    static Iterator<String> create(String normalizedPath, int driveStrLength) {
        return normalizedPath.length() > driveStrLength ? new PathSegmentIterator(normalizedPath, driveStrLength) : Collections.emptyIterator();
    }

    private PathSegmentIterator(String normalizedPath, int driveStrLength) {
        this.normalizedPath = normalizedPath;
        this.start = driveStrLength;
    }

    @Override
    public boolean hasNext() {
        return this.start < this.normalizedPath.length();
    }

    @Override
    public String next() {
        int end;
        if (!this.hasNext()) {
            throw new NoSuchElementException("No more segments: " + this.normalizedPath);
        }
        for (end = this.start + 1; end < this.normalizedPath.length() && this.normalizedPath.charAt(end) != '/'; ++end) {
        }
        String segment = this.normalizedPath.substring(this.start, end);
        this.start = end + 1;
        return segment;
    }
}

