/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.vfs;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.devtools.build.lib.actions.CommandLineItem;
import com.google.devtools.build.lib.skyframe.serialization.DeserializationContext;
import com.google.devtools.build.lib.skyframe.serialization.ObjectCodec;
import com.google.devtools.build.lib.skyframe.serialization.SerializationContext;
import com.google.devtools.build.lib.skyframe.serialization.SerializationException;
import com.google.devtools.build.lib.skyframe.serialization.autocodec.SerializationConstant;
import com.google.devtools.build.lib.util.FileType;
import com.google.devtools.build.lib.vfs.OsPathPolicy;
import com.google.devtools.build.lib.vfs.PathSegmentIterator;
import com.google.errorprone.annotations.Immutable;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import java.io.IOException;
import javax.annotation.Nullable;

@Immutable
public abstract class PathFragment
implements Comparable<PathFragment>,
FileType.HasFileType,
CommandLineItem {
    private static final OsPathPolicy OS = OsPathPolicy.getFilePathOs();
    @SerializationConstant
    public static final PathFragment EMPTY_FRAGMENT = new RelativePathFragment("");
    public static final char SEPARATOR_CHAR = '/';
    private static final char ADDITIONAL_SEPARATOR_CHAR = OS.additionalSeparator();
    private final String normalizedPath;

    public static PathFragment create(String path) {
        if (path.isEmpty()) {
            return EMPTY_FRAGMENT;
        }
        int normalizationLevel = OS.needsToNormalize(path);
        String normalizedPath = normalizationLevel != 0 ? OS.normalize(path, normalizationLevel) : path;
        int driveStrLength = OS.getDriveStrLength(normalizedPath);
        return PathFragment.makePathFragment(normalizedPath, driveStrLength);
    }

    private static PathFragment makePathFragment(String normalizedPath, int driveStrLength) {
        switch (driveStrLength) {
            case 0: {
                return new RelativePathFragment(normalizedPath);
            }
            case 1: {
                return new UnixStyleAbsolutePathFragment(normalizedPath);
            }
            case 3: {
                return new WindowsStyleAbsolutePathFragment(normalizedPath);
            }
        }
        throw new IllegalStateException(String.format("normalizedPath: %s, driveStrLength: %s", normalizedPath, driveStrLength));
    }

    public static PathFragment createAlreadyNormalized(String normalizedPath) {
        return normalizedPath.isEmpty() ? EMPTY_FRAGMENT : PathFragment.makePathFragment(normalizedPath, OS.getDriveStrLength(normalizedPath));
    }

    private PathFragment(String normalizedPath) {
        this.normalizedPath = Preconditions.checkNotNull(normalizedPath);
    }

    public String getPathString() {
        return this.normalizedPath;
    }

    public boolean isEmpty() {
        return this.normalizedPath.isEmpty();
    }

    public abstract int getDriveStrLength();

    public String getBaseName() {
        int lastSeparator = this.normalizedPath.lastIndexOf(47);
        return lastSeparator < this.getDriveStrLength() ? this.normalizedPath.substring(this.getDriveStrLength()) : this.normalizedPath.substring(lastSeparator + 1);
    }

    public PathFragment getRelative(PathFragment other) {
        Preconditions.checkNotNull(other);
        String otherStr = other.normalizedPath;
        return this.getRelative(otherStr, other.getDriveStrLength(), OS.needsToNormalizeSuffix(otherStr));
    }

    public PathFragment getRelative(String other) {
        Preconditions.checkNotNull(other);
        return this.getRelative(other, OS.getDriveStrLength(other), OS.needsToNormalize(other));
    }

    private PathFragment getRelative(String other, int otherDriveStrLength, int normalizationLevel) {
        if (this.normalizedPath.isEmpty()) {
            return PathFragment.create(other);
        }
        if (other.isEmpty()) {
            return this;
        }
        if (otherDriveStrLength > 0) {
            String normalizedPath = normalizationLevel != 0 ? OS.normalize(other, normalizationLevel) : other;
            return PathFragment.makePathFragment(normalizedPath, otherDriveStrLength);
        }
        String newPath = this.normalizedPath.length() == this.getDriveStrLength() ? this.normalizedPath + other : this.normalizedPath + "/" + other;
        newPath = normalizationLevel != 0 ? OS.normalize(newPath, normalizationLevel) : newPath;
        return PathFragment.makePathFragment(newPath, this.getDriveStrLength());
    }

    public static boolean isNormalizedRelativePath(String path) {
        int driveStrLength = OS.getDriveStrLength(path);
        int normalizationLevel = OS.needsToNormalize(path);
        return driveStrLength == 0 && normalizationLevel == 0;
    }

    public static boolean containsSeparator(String path) {
        return path.lastIndexOf(47) != -1;
    }

    public PathFragment getChild(String baseName) {
        PathFragment.checkBaseName(baseName);
        String newPath = this.normalizedPath.length() == this.getDriveStrLength() ? this.normalizedPath + baseName : this.normalizedPath + "/" + baseName;
        return PathFragment.makePathFragment(newPath, this.getDriveStrLength());
    }

    @Nullable
    public PathFragment getParentDirectory() {
        int lastSeparator = this.normalizedPath.lastIndexOf(47);
        if (this.getDriveStrLength() > 0) {
            if (lastSeparator < this.getDriveStrLength()) {
                if (this.normalizedPath.length() > this.getDriveStrLength()) {
                    String newPath = this.normalizedPath.substring(0, this.getDriveStrLength());
                    return PathFragment.makePathFragment(newPath, this.getDriveStrLength());
                }
                return null;
            }
        } else if (lastSeparator == -1) {
            if (!this.normalizedPath.isEmpty()) {
                return EMPTY_FRAGMENT;
            }
            return null;
        }
        String newPath = this.normalizedPath.substring(0, lastSeparator);
        return PathFragment.makePathFragment(newPath, this.getDriveStrLength());
    }

    public PathFragment relativeTo(PathFragment base) {
        Preconditions.checkNotNull(base);
        if (this.isAbsolute() != base.isAbsolute()) {
            throw new IllegalArgumentException("Cannot relativize an absolute and a non-absolute path pair");
        }
        String basePath = base.normalizedPath;
        if (!OS.startsWith(this.normalizedPath, basePath)) {
            throw new IllegalArgumentException(String.format("Path '%s' is not under '%s', cannot relativize", this, base));
        }
        int bn = basePath.length();
        if (bn == 0) {
            return this;
        }
        if (this.normalizedPath.length() == bn) {
            return EMPTY_FRAGMENT;
        }
        int lastSlashIndex = basePath.charAt(bn - 1) == '/' ? bn - 1 : bn;
        if (this.normalizedPath.charAt(lastSlashIndex) != '/') {
            throw new IllegalArgumentException(String.format("Path '%s' is not under '%s', cannot relativize", this, base));
        }
        String newPath = this.normalizedPath.substring(lastSlashIndex + 1);
        return new RelativePathFragment(newPath);
    }

    public PathFragment relativeTo(String base) {
        return this.relativeTo(PathFragment.create(base));
    }

    public boolean startsWith(PathFragment other) {
        Preconditions.checkNotNull(other);
        if (other.normalizedPath.length() > this.normalizedPath.length()) {
            return false;
        }
        if (this.getDriveStrLength() != other.getDriveStrLength()) {
            return false;
        }
        if (!OS.startsWith(this.normalizedPath, other.normalizedPath)) {
            return false;
        }
        return this.normalizedPath.length() == other.normalizedPath.length() || other.normalizedPath.length() == this.getDriveStrLength() || this.normalizedPath.charAt(other.normalizedPath.length()) == '/';
    }

    public boolean endsWith(PathFragment other) {
        Preconditions.checkNotNull(other);
        if (other.normalizedPath.length() > this.normalizedPath.length()) {
            return false;
        }
        if (other.isAbsolute()) {
            return this.equals(other);
        }
        if (!OS.endsWith(this.normalizedPath, other.normalizedPath)) {
            return false;
        }
        return this.normalizedPath.length() == other.normalizedPath.length() || other.normalizedPath.isEmpty() || this.normalizedPath.charAt(this.normalizedPath.length() - other.normalizedPath.length() - 1) == '/';
    }

    public boolean isAbsolute() {
        return this.getDriveStrLength() > 0;
    }

    public static boolean isAbsolute(String path) {
        return OS.getDriveStrLength(path) > 0;
    }

    public String toString() {
        return this.normalizedPath;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return OS.equals(this.normalizedPath, ((PathFragment)o).normalizedPath);
    }

    public int hashCode() {
        return OS.hash(this.normalizedPath);
    }

    @Override
    public int compareTo(PathFragment o) {
        return OS.compare(this.normalizedPath, o.normalizedPath);
    }

    public int segmentCount() {
        int i;
        int n = this.normalizedPath.length();
        int segmentCount = 0;
        for (i = this.getDriveStrLength(); i < n; ++i) {
            if (this.normalizedPath.charAt(i) != '/') continue;
            ++segmentCount;
        }
        if (i > this.getDriveStrLength()) {
            ++segmentCount;
        }
        return segmentCount;
    }

    public boolean isSingleSegment() {
        return this.normalizedPath.length() > this.getDriveStrLength() && !this.isMultiSegment();
    }

    public boolean isMultiSegment() {
        return this.normalizedPath.indexOf(47, this.getDriveStrLength()) >= 0;
    }

    public String getSegment(int index) {
        int i;
        int n = this.normalizedPath.length();
        int segmentCount = 0;
        for (i = this.getDriveStrLength(); i < n && segmentCount < index; ++i) {
            if (this.normalizedPath.charAt(i) != '/') continue;
            ++segmentCount;
        }
        int starti = i;
        while (i < n && this.normalizedPath.charAt(i) != '/') {
            ++i;
        }
        if (i > this.getDriveStrLength()) {
            ++segmentCount;
        }
        int endi = i;
        if (index < 0 || index >= segmentCount) {
            throw new IllegalArgumentException("Illegal segment index: " + index);
        }
        return this.normalizedPath.substring(starti, endi);
    }

    public PathFragment subFragment(int beginIndex, int endIndex) {
        if (beginIndex < 0 || beginIndex > endIndex) {
            throw new IndexOutOfBoundsException(String.format("path: %s, beginIndex: %d endIndex: %d", this.toString(), beginIndex, endIndex));
        }
        return this.subFragmentImpl(beginIndex, endIndex);
    }

    public PathFragment subFragment(int beginIndex) {
        if (beginIndex < 0) {
            throw new IndexOutOfBoundsException(String.format("path: %s, beginIndex: %d", this.toString(), beginIndex));
        }
        return this.subFragmentImpl(beginIndex, -1);
    }

    private PathFragment subFragmentImpl(int beginIndex, int endIndex) {
        int i;
        int n = this.normalizedPath.length();
        int segmentIndex = 0;
        for (i = this.getDriveStrLength(); i < n && segmentIndex < beginIndex; ++i) {
            if (this.normalizedPath.charAt(i) != '/') continue;
            ++segmentIndex;
        }
        int starti = i;
        if (segmentIndex < endIndex) {
            while (i < n && (this.normalizedPath.charAt(i) != '/' || ++segmentIndex != endIndex)) {
                ++i;
            }
        } else if (endIndex == -1) {
            i = this.normalizedPath.length();
        }
        int endi = i;
        if (i == n && i > this.getDriveStrLength()) {
            ++segmentIndex;
        }
        if (beginIndex > segmentIndex || endIndex > segmentIndex) {
            throw new IndexOutOfBoundsException(String.format("path: %s, beginIndex: %d endIndex: %d", this.toString(), beginIndex, endIndex));
        }
        int driveStrLength = 0;
        if (beginIndex == 0) {
            starti = 0;
            driveStrLength = this.getDriveStrLength();
            endi = Math.max(endi, driveStrLength);
        }
        return PathFragment.makePathFragment(this.normalizedPath.substring(starti, endi), driveStrLength);
    }

    public Iterable<String> segments() {
        return () -> PathSegmentIterator.create(this.normalizedPath, this.getDriveStrLength());
    }

    public ImmutableList<String> splitToListOfSegments() {
        ImmutableList.Builder segments = ImmutableList.builderWithExpectedSize(this.segmentCount());
        int nexti = this.getDriveStrLength();
        int n = this.normalizedPath.length();
        for (int i = this.getDriveStrLength(); i < n; ++i) {
            if (this.normalizedPath.charAt(i) != '/') continue;
            segments.add(this.normalizedPath.substring(nexti, i));
            nexti = i + 1;
        }
        if (nexti < n) {
            segments.add(this.normalizedPath.substring(nexti));
        }
        return segments.build();
    }

    public String getSafePathString() {
        return !this.normalizedPath.isEmpty() ? this.normalizedPath : ".";
    }

    public String getCallablePathString() {
        if (this.isAbsolute()) {
            return this.normalizedPath;
        }
        if (this.normalizedPath.isEmpty()) {
            return ".";
        }
        if (this.normalizedPath.indexOf(47) == -1) {
            return "./" + this.normalizedPath;
        }
        return this.normalizedPath;
    }

    public String getFileExtension() {
        int n = this.normalizedPath.length();
        for (int i = n - 1; i > this.getDriveStrLength(); --i) {
            char c = this.normalizedPath.charAt(i);
            if (c == '.') {
                return this.normalizedPath.substring(i + 1, n);
            }
            if (c == '/') break;
        }
        return "";
    }

    @Nullable
    public PathFragment replaceName(String newName) {
        PathFragment parent = this.getParentDirectory();
        return parent != null ? parent.getRelative(newName) : null;
    }

    public String getDriveStr() {
        Preconditions.checkArgument(this.isAbsolute());
        return this.normalizedPath.substring(0, this.getDriveStrLength());
    }

    public PathFragment toRelative() {
        Preconditions.checkArgument(this.isAbsolute());
        return PathFragment.makePathFragment(this.normalizedPath.substring(this.getDriveStrLength()), 0);
    }

    public boolean containsUplevelReferences() {
        return this.normalizedPath.startsWith("..") && (this.normalizedPath.length() == 2 || this.normalizedPath.charAt(2) == '/');
    }

    public static boolean containsUplevelReferences(String path) {
        return !PathFragment.isNormalizedImpl(path, false);
    }

    public static boolean isNormalized(String path) {
        return PathFragment.isNormalizedImpl(path, true);
    }

    private static boolean isNormalizedImpl(String path, boolean lookForSameLevelReferences) {
        NormalizedImplState state = NormalizedImplState.Separator;
        int n = path.length();
        block10: for (int i = 0; i < n; ++i) {
            char c = path.charAt(i);
            boolean isSeparator = OS.isSeparator(c);
            switch (state) {
                case Base: {
                    if (isSeparator) {
                        state = NormalizedImplState.Separator;
                        continue block10;
                    }
                    state = NormalizedImplState.Base;
                    continue block10;
                }
                case Separator: {
                    if (isSeparator) {
                        state = NormalizedImplState.Separator;
                        continue block10;
                    }
                    if (c == '.') {
                        state = NormalizedImplState.Dot;
                        continue block10;
                    }
                    state = NormalizedImplState.Base;
                    continue block10;
                }
                case Dot: {
                    if (isSeparator) {
                        if (lookForSameLevelReferences) {
                            return false;
                        }
                        state = NormalizedImplState.Separator;
                        continue block10;
                    }
                    if (c == '.') {
                        state = NormalizedImplState.DotDot;
                        continue block10;
                    }
                    state = NormalizedImplState.Base;
                    continue block10;
                }
                case DotDot: {
                    if (isSeparator) {
                        return false;
                    }
                    state = NormalizedImplState.Base;
                    continue block10;
                }
                default: {
                    throw new IllegalStateException("Unhandled state: " + state);
                }
            }
        }
        switch (state) {
            case Dot: {
                if (!lookForSameLevelReferences) break;
                return false;
            }
            case DotDot: {
                return false;
            }
        }
        return true;
    }

    public static void checkAllPathsAreUnder(Iterable<PathFragment> paths, PathFragment startingWithPath) {
        for (PathFragment path : paths) {
            Preconditions.checkArgument(!path.equals(startingWithPath) && path.startsWith(startingWithPath), "%s is not beneath %s", (Object)path, (Object)startingWithPath);
        }
    }

    @Override
    public String filePathForFileTypeMatcher() {
        return this.normalizedPath;
    }

    @Override
    public String expandToCommandLine() {
        return this.normalizedPath;
    }

    private static void checkBaseName(String baseName) {
        if (baseName.isEmpty()) {
            throw new IllegalArgumentException("Child must not be empty string ('')");
        }
        if (baseName.equals(".") || baseName.equals("..")) {
            throw new IllegalArgumentException("baseName must not be '" + baseName + "'");
        }
        try {
            PathFragment.checkSeparators(baseName);
        }
        catch (InvalidBaseNameException e) {
            throw new IllegalArgumentException("baseName " + e.getMessage() + ": '" + baseName + "'", e);
        }
    }

    public static void checkSeparators(String baseName) throws InvalidBaseNameException {
        if (baseName.indexOf(47) != -1) {
            throw new InvalidBaseNameException("must not contain /");
        }
        if (ADDITIONAL_SEPARATOR_CHAR != '\u0000' && baseName.indexOf(ADDITIONAL_SEPARATOR_CHAR) != -1) {
            throw new InvalidBaseNameException("must not contain " + ADDITIONAL_SEPARATOR_CHAR);
        }
    }

    private static class Codec
    implements ObjectCodec<PathFragment> {
        private Codec() {
        }

        @Override
        public Class<PathFragment> getEncodedClass() {
            return PathFragment.class;
        }

        @Override
        public void serialize(SerializationContext context, PathFragment obj, CodedOutputStream codedOut) throws SerializationException, IOException {
            context.serialize(obj.normalizedPath, codedOut);
        }

        @Override
        public PathFragment deserialize(DeserializationContext context, CodedInputStream codedIn) throws SerializationException, IOException {
            return PathFragment.createAlreadyNormalized((String)context.deserialize(codedIn));
        }
    }

    public static final class InvalidBaseNameException
    extends Exception {
        private InvalidBaseNameException(String message) {
            super(message);
        }
    }

    private static enum NormalizedImplState {
        Base,
        Separator,
        Dot,
        DotDot;

    }

    private static final class WindowsStyleAbsolutePathFragment
    extends PathFragment {
        private WindowsStyleAbsolutePathFragment(String normalizedPath) {
            super(normalizedPath);
        }

        @Override
        public int getDriveStrLength() {
            return 3;
        }
    }

    private static final class UnixStyleAbsolutePathFragment
    extends PathFragment {
        private UnixStyleAbsolutePathFragment(String normalizedPath) {
            super(normalizedPath);
        }

        @Override
        public int getDriveStrLength() {
            return 1;
        }
    }

    private static final class RelativePathFragment
    extends PathFragment {
        private RelativePathFragment(String normalizedPath) {
            super(normalizedPath);
        }

        @Override
        public int getDriveStrLength() {
            return 0;
        }
    }
}

