/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.vfs;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.hash.Hasher;
import com.google.devtools.build.lib.skyframe.serialization.autocodec.AutoCodec;
import com.google.devtools.build.lib.util.FileType;
import com.google.devtools.build.lib.vfs.DigestUtils;
import com.google.devtools.build.lib.vfs.Dirent;
import com.google.devtools.build.lib.vfs.FileStatus;
import com.google.devtools.build.lib.vfs.FileSystem;
import com.google.devtools.build.lib.vfs.FileSystemUtils;
import com.google.devtools.build.lib.vfs.PathFragment;
import com.google.devtools.build.lib.vfs.Symlinks;
import com.google.devtools.build.lib.vfs.XattrProvider;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SeekableByteChannel;
import java.util.ArrayList;
import java.util.Collection;
import javax.annotation.Nullable;

@AutoCodec
public class Path
implements Comparable<Path>,
FileType.HasFileType {
    public static final long NOW_SENTINEL_TIME = -1L;
    private final PathFragment pathFragment;
    private final FileSystem fileSystem;

    static Path create(String path, FileSystem fileSystem) {
        Preconditions.checkNotNull(path);
        return Path.create(PathFragment.create(path), fileSystem);
    }

    @AutoCodec.Instantiator
    static Path create(PathFragment pathFragment, FileSystem fileSystem) {
        return new Path(pathFragment, fileSystem);
    }

    private Path(PathFragment pathFragment, FileSystem fileSystem) {
        Preconditions.checkArgument(pathFragment.isAbsolute(), "Paths must be absolute: '%s'", (Object)pathFragment);
        this.pathFragment = pathFragment;
        this.fileSystem = fileSystem;
    }

    public String getPathString() {
        return this.pathFragment.getPathString();
    }

    @Override
    public String filePathForFileTypeMatcher() {
        return this.pathFragment.getPathString();
    }

    public String getBaseName() {
        return this.pathFragment.getBaseName();
    }

    public Path getChild(String child) {
        FileSystemUtils.checkBaseName(child);
        return this.getRelative(child);
    }

    public Path getRelative(PathFragment other) {
        Preconditions.checkNotNull(other);
        return new Path(this.pathFragment.getRelative(other), this.fileSystem);
    }

    public Path getRelative(String other) {
        Preconditions.checkNotNull(other);
        return new Path(this.pathFragment.getRelative(other), this.fileSystem);
    }

    @Nullable
    public Path getParentDirectory() {
        PathFragment parentPath = this.pathFragment.getParentDirectory();
        if (parentPath == null) {
            return null;
        }
        return new Path(parentPath, this.fileSystem);
    }

    public PathFragment relativeTo(Path base) {
        Preconditions.checkNotNull(base);
        this.checkSameFileSystem(base);
        return this.pathFragment.relativeTo(base.pathFragment);
    }

    public boolean startsWith(Path other) {
        if (this.fileSystem != other.fileSystem) {
            return false;
        }
        return this.pathFragment.startsWith(other.pathFragment);
    }

    public boolean startsWith(PathFragment other) {
        return this.pathFragment.startsWith(other);
    }

    public FileSystem getFileSystem() {
        return this.fileSystem;
    }

    public PathFragment asFragment() {
        return this.pathFragment;
    }

    public String toString() {
        return this.pathFragment.getPathString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Path)) {
            return false;
        }
        Path other = (Path)o;
        return this.fileSystem == other.fileSystem && this.pathFragment.equals(other.pathFragment);
    }

    public int hashCode() {
        return this.pathFragment.hashCode();
    }

    @Override
    public int compareTo(Path o) {
        FileSystem otherFs = o.fileSystem;
        if (!this.fileSystem.equals(otherFs)) {
            int otherFileSystemHash;
            int thisFileSystemHash = System.identityHashCode(this.fileSystem);
            if (thisFileSystemHash < (otherFileSystemHash = System.identityHashCode(otherFs))) {
                return -1;
            }
            if (thisFileSystemHash > otherFileSystemHash) {
                return 1;
            }
        }
        return this.pathFragment.compareTo(o.pathFragment);
    }

    public boolean exists() {
        return this.fileSystem.exists(this.asFragment(), true);
    }

    public boolean exists(Symlinks followSymlinks) {
        return this.fileSystem.exists(this.asFragment(), followSymlinks.toBoolean());
    }

    public Collection<Path> getDirectoryEntries() throws IOException, FileNotFoundException {
        Collection<String> entries = this.fileSystem.getDirectoryEntries(this.asFragment());
        ArrayList<Path> result = new ArrayList<Path>(entries.size());
        for (String entry : entries) {
            result.add(this.getChild(entry));
        }
        return result;
    }

    public Collection<Dirent> readdir(Symlinks followSymlinks) throws IOException {
        return this.fileSystem.readdir(this.asFragment(), followSymlinks.toBoolean());
    }

    public FileStatus stat() throws IOException {
        return this.fileSystem.stat(this.asFragment(), true);
    }

    public FileStatus stat(Symlinks followSymlinks) throws IOException {
        return this.fileSystem.stat(this.asFragment(), followSymlinks.toBoolean());
    }

    public FileStatus statNullable() {
        return this.statNullable(Symlinks.FOLLOW);
    }

    public FileStatus statNullable(Symlinks symlinks) {
        return this.fileSystem.statNullable(this.asFragment(), symlinks.toBoolean());
    }

    public FileStatus statIfFound() throws IOException {
        return this.fileSystem.statIfFound(this.asFragment(), true);
    }

    public FileStatus statIfFound(Symlinks followSymlinks) throws IOException {
        return this.fileSystem.statIfFound(this.asFragment(), followSymlinks.toBoolean());
    }

    public boolean isDirectory() {
        return this.fileSystem.isDirectory(this.asFragment(), true);
    }

    public boolean isDirectory(Symlinks followSymlinks) {
        return this.fileSystem.isDirectory(this.asFragment(), followSymlinks.toBoolean());
    }

    public boolean isFile() {
        return this.fileSystem.isFile(this.asFragment(), true);
    }

    public boolean isFile(Symlinks followSymlinks) {
        return this.fileSystem.isFile(this.asFragment(), followSymlinks.toBoolean());
    }

    public boolean isSpecialFile() {
        return this.fileSystem.isSpecialFile(this.asFragment(), true);
    }

    public boolean isSpecialFile(Symlinks followSymlinks) {
        return this.fileSystem.isSpecialFile(this.asFragment(), followSymlinks.toBoolean());
    }

    public boolean isSymbolicLink() {
        return this.fileSystem.isSymbolicLink(this.asFragment());
    }

    public OutputStream getOutputStream() throws IOException {
        return this.getOutputStream(false);
    }

    public OutputStream getOutputStream(boolean append) throws IOException {
        return this.fileSystem.getOutputStream(this.asFragment(), append);
    }

    public OutputStream getOutputStream(boolean append, boolean internal) throws IOException {
        return this.fileSystem.getOutputStream(this.asFragment(), append, internal);
    }

    public boolean createDirectory() throws IOException {
        return this.fileSystem.createDirectory(this.asFragment());
    }

    public boolean createWritableDirectory() throws IOException {
        return this.fileSystem.createWritableDirectory(this.asFragment());
    }

    public void createDirectoryAndParents() throws IOException {
        this.fileSystem.createDirectoryAndParents(this.asFragment());
    }

    public void createSymbolicLink(Path target) throws IOException {
        this.checkSameFileSystem(target);
        this.fileSystem.createSymbolicLink(this.asFragment(), target.asFragment());
    }

    public void createSymbolicLink(PathFragment target) throws IOException {
        this.fileSystem.createSymbolicLink(this.asFragment(), target);
    }

    public PathFragment readSymbolicLink() throws IOException {
        return this.fileSystem.readSymbolicLink(this.asFragment());
    }

    public PathFragment readSymbolicLinkUnchecked() throws IOException {
        return this.fileSystem.readSymbolicLinkUnchecked(this.asFragment());
    }

    public void createHardLink(Path link) throws IOException {
        this.fileSystem.createHardLink(link.asFragment(), this.asFragment());
    }

    public Path resolveSymbolicLinks() throws IOException {
        return this.fileSystem.resolveSymbolicLinks(this.asFragment());
    }

    public void renameTo(Path target) throws IOException {
        this.checkSameFileSystem(target);
        this.fileSystem.renameTo(this.asFragment(), target.asFragment());
    }

    public long getFileSize() throws IOException, FileNotFoundException {
        return this.fileSystem.getFileSize(this.asFragment(), true);
    }

    public long getFileSize(Symlinks followSymlinks) throws IOException, FileNotFoundException {
        return this.fileSystem.getFileSize(this.asFragment(), followSymlinks.toBoolean());
    }

    public boolean delete() throws IOException {
        return this.fileSystem.delete(this.asFragment());
    }

    public void deleteTree() throws IOException {
        this.fileSystem.deleteTree(this.asFragment());
    }

    public void deleteTreesBelow() throws IOException {
        this.fileSystem.deleteTreesBelow(this.asFragment());
    }

    public long getLastModifiedTime() throws IOException {
        return this.fileSystem.getLastModifiedTime(this.asFragment(), true);
    }

    public long getLastModifiedTime(Symlinks followSymlinks) throws IOException {
        return this.fileSystem.getLastModifiedTime(this.asFragment(), followSymlinks.toBoolean());
    }

    public void setLastModifiedTime(long newTime) throws IOException {
        this.fileSystem.setLastModifiedTime(this.asFragment(), newTime);
    }

    public byte[] getxattr(String name) throws IOException {
        return this.getxattr(name, Symlinks.FOLLOW);
    }

    public byte[] getxattr(String name, Symlinks followSymlinks) throws IOException {
        return this.fileSystem.getxattr(this.asFragment(), name, followSymlinks.toBoolean());
    }

    public byte[] getFastDigest() throws IOException {
        return this.fileSystem.getFastDigest(this.asFragment());
    }

    public byte[] getDigest() throws IOException {
        return this.fileSystem.getDigest(this.asFragment());
    }

    public String getDirectoryDigest(XattrProvider xattrProvider) throws IOException {
        ImmutableList<String> entries = ImmutableList.sortedCopyOf(this.fileSystem.getDirectoryEntries(this.asFragment()));
        Hasher hasher = this.fileSystem.getDigestFunction().getHashFunction().newHasher();
        for (String entry : entries) {
            Path path = this.getChild(entry);
            FileStatus stat = path.stat(Symlinks.NOFOLLOW);
            hasher.putUnencodedChars(entry);
            if (stat.isFile()) {
                if (path.isExecutable()) {
                    hasher.putChar('x');
                } else {
                    hasher.putChar('-');
                }
                hasher.putBytes(DigestUtils.getDigestWithManualFallback(path, stat.getSize(), xattrProvider));
                continue;
            }
            if (stat.isDirectory()) {
                hasher.putChar('d').putUnencodedChars(path.getDirectoryDigest(xattrProvider));
                continue;
            }
            if (stat.isSymbolicLink()) {
                PathFragment link = path.readSymbolicLink();
                if (link.isAbsolute()) {
                    try {
                        Path resolved = path.resolveSymbolicLinks();
                        if (resolved.isFile()) {
                            if (resolved.isExecutable()) {
                                hasher.putChar('x');
                            } else {
                                hasher.putChar('-');
                            }
                            hasher.putBytes(DigestUtils.getDigestWithManualFallbackWhenSizeUnknown(resolved, xattrProvider));
                            continue;
                        }
                        hasher.putChar('l').putUnencodedChars(link.toString());
                    }
                    catch (IOException e) {
                        hasher.putChar('l').putUnencodedChars(link.toString());
                    }
                    continue;
                }
                hasher.putChar('l').putUnencodedChars(link.toString());
                continue;
            }
            hasher.putChar('s');
        }
        return hasher.hash().toString();
    }

    public InputStream getInputStream() throws IOException {
        return this.fileSystem.getInputStream(this.asFragment());
    }

    public ReadableByteChannel createReadableByteChannel() throws IOException {
        return this.fileSystem.createReadableByteChannel(this.asFragment());
    }

    public SeekableByteChannel createReadWriteByteChannel() throws IOException {
        return this.fileSystem.createReadWriteByteChannel(this.asFragment());
    }

    public File getPathFile() {
        return new File(this.getPathString());
    }

    public boolean isWritable() throws IOException {
        return this.fileSystem.isWritable(this.asFragment());
    }

    public void setReadable(boolean readable) throws IOException, FileNotFoundException {
        this.fileSystem.setReadable(this.asFragment(), readable);
    }

    public void setWritable(boolean writable) throws IOException, FileNotFoundException {
        this.fileSystem.setWritable(this.asFragment(), writable);
    }

    public boolean isExecutable() throws IOException, FileNotFoundException {
        return this.fileSystem.isExecutable(this.asFragment());
    }

    public boolean isReadable() throws IOException, FileNotFoundException {
        return this.fileSystem.isReadable(this.asFragment());
    }

    public void setExecutable(boolean executable) throws IOException, FileNotFoundException {
        this.fileSystem.setExecutable(this.asFragment(), executable);
    }

    public void chmod(int mode) throws IOException {
        this.fileSystem.chmod(this.asFragment(), mode);
    }

    public void prefetchPackageAsync(int maxDirs) {
        this.fileSystem.prefetchPackageAsync(this.asFragment(), maxDirs);
    }

    private void checkSameFileSystem(Path that) {
        if (this.fileSystem != that.fileSystem) {
            throw new IllegalArgumentException("Files are on different filesystems: " + this + ", " + that);
        }
    }
}

