/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.vfs;

import com.google.devtools.build.lib.util.OS;
import com.google.devtools.build.lib.vfs.UnixOsPathPolicy;
import com.google.devtools.build.lib.vfs.WindowsOsPathPolicy;

public interface OsPathPolicy {
    public static final int NORMALIZED = 0;
    public static final int NEEDS_NORMALIZE = 1;
    public static final OsPathPolicy HOST_POLICY = OS.getCurrent() == OS.WINDOWS ? WindowsOsPathPolicy.INSTANCE : UnixOsPathPolicy.INSTANCE;

    public int needsToNormalize(String var1);

    public int needsToNormalizeSuffix(String var1);

    public String normalize(String var1, int var2);

    public int getDriveStrLength(String var1);

    public int compare(String var1, String var2);

    public int compare(char var1, char var2);

    public boolean equals(String var1, String var2);

    public int hash(String var1);

    public boolean startsWith(String var1, String var2);

    public boolean endsWith(String var1, String var2);

    public boolean isSeparator(char var1);

    public char additionalSeparator();

    public boolean isCaseSensitive();

    public static OsPathPolicy getFilePathOs() {
        return HOST_POLICY;
    }

    public static class Utils {
        static int removeRelativePaths(String[] segments, int starti, boolean isAbsolute) {
            int segmentCount = 0;
            int shift = starti;
            int n = segments.length;
            block8: for (int i = starti; i < n; ++i) {
                String segment;
                switch (segment = segments[i]) {
                    case ".": {
                        ++shift;
                        continue block8;
                    }
                    case "..": {
                        if (segmentCount > 0 && !segments[segmentCount - 1].equals("..")) {
                            --segmentCount;
                            shift += 2;
                            continue block8;
                        }
                        if (isAbsolute) {
                            ++shift;
                            continue block8;
                        }
                    }
                    default: {
                        ++segmentCount;
                        if (shift <= 0) continue block8;
                        segments[i - shift] = segments[i];
                    }
                }
            }
            return segmentCount;
        }
    }
}

