/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.vfs;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableSet;
import com.google.devtools.build.lib.vfs.PathFragment;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.Objects;
import javax.annotation.Nullable;

public class ModifiedFileSet {
    public static final ModifiedFileSet EVERYTHING_MODIFIED = new ModifiedFileSet(null);
    public static final ModifiedFileSet EVERYTHING_DELETED = new ModifiedFileSet(null){

        @Override
        public boolean treatEverythingAsDeleted() {
            return true;
        }
    };
    public static final ModifiedFileSet NOTHING_MODIFIED = new ModifiedFileSet(ImmutableSet.of());
    @Nullable
    private final ImmutableSet<PathFragment> modified;

    public boolean treatEverythingAsModified() {
        return this.modified == null;
    }

    public boolean treatEverythingAsDeleted() {
        return false;
    }

    public ImmutableSet<PathFragment> modifiedSourceFiles() {
        if (this.treatEverythingAsModified()) {
            throw new IllegalStateException();
        }
        return this.modified;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ModifiedFileSet)) {
            return false;
        }
        ModifiedFileSet other = (ModifiedFileSet)o;
        return this.treatEverythingAsModified() == other.treatEverythingAsModified() && this.treatEverythingAsDeleted() == other.treatEverythingAsDeleted() && Objects.equals(this.modified, other.modified);
    }

    public int hashCode() {
        return 31 * Objects.hashCode(this.modified) + Boolean.hashCode(this.treatEverythingAsDeleted());
    }

    public String toString() {
        if (this.equals(EVERYTHING_DELETED)) {
            return "EVERYTHING_DELETED";
        }
        if (this.equals(EVERYTHING_MODIFIED)) {
            return "EVERYTHING_MODIFIED";
        }
        if (this.equals(NOTHING_MODIFIED)) {
            return "NOTHING_MODIFIED";
        }
        return this.modified.toString();
    }

    private ModifiedFileSet(ImmutableSet<PathFragment> modified) {
        this.modified = modified;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final ImmutableSet.Builder<PathFragment> setBuilder = ImmutableSet.builder();

        public ModifiedFileSet build() {
            ImmutableCollection modified = this.setBuilder.build();
            return modified.isEmpty() ? NOTHING_MODIFIED : new ModifiedFileSet((ImmutableSet<PathFragment>)modified);
        }

        @CanIgnoreReturnValue
        public Builder modify(PathFragment pathFragment) {
            this.setBuilder.add((Object)pathFragment);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder modifyAll(Iterable<PathFragment> pathFragments) {
            this.setBuilder.addAll((Iterable)pathFragments);
            return this;
        }
    }
}

