/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.vfs;

import com.google.common.annotations.VisibleForTesting;
import com.google.devtools.build.lib.clock.Clock;
import com.google.devtools.build.lib.clock.JavaClock;
import com.google.devtools.build.lib.profiler.Profiler;
import com.google.devtools.build.lib.profiler.ProfilerTask;
import com.google.devtools.build.lib.vfs.AbstractFileSystemWithCustomStat;
import com.google.devtools.build.lib.vfs.DigestHashFunction;
import com.google.devtools.build.lib.vfs.FileAccessException;
import com.google.devtools.build.lib.vfs.FileStatus;
import com.google.devtools.build.lib.vfs.FileSystem;
import com.google.devtools.build.lib.vfs.PathFragment;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.AccessDeniedException;
import java.nio.file.AtomicMoveNotSupportedException;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileSystemException;
import java.nio.file.FileSystemLoopException;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.NotDirectoryException;
import java.nio.file.NotLinkException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import javax.annotation.Nullable;

public class JavaIoFileSystem
extends AbstractFileSystemWithCustomStat {
    private static final LinkOption[] NO_LINK_OPTION = new LinkOption[0];
    private static final LinkOption[] NOFOLLOW_LINKS_OPTION = new LinkOption[]{LinkOption.NOFOLLOW_LINKS};
    private final Clock clock;
    protected static final String ERR_IS_DIRECTORY = " (Is a directory)";
    protected static final String ERR_DIRECTORY_NOT_EMPTY = " (Directory not empty)";
    protected static final String ERR_FILE_EXISTS = " (File exists)";
    protected static final String ERR_NO_SUCH_FILE_OR_DIR = " (No such file or directory)";
    protected static final String ERR_NOT_A_DIRECTORY = " (Not a directory)";

    public JavaIoFileSystem(DigestHashFunction hashFunction) {
        super(hashFunction);
        this.clock = new JavaClock();
    }

    @VisibleForTesting
    JavaIoFileSystem(Clock clock, DigestHashFunction hashFunction) {
        super(hashFunction);
        this.clock = clock;
    }

    protected File getIoFile(PathFragment path) {
        return new File(path.toString());
    }

    protected Path getNioPath(PathFragment path) {
        return Paths.get(path.toString(), new String[0]);
    }

    private LinkOption[] linkOpts(boolean followSymlinks) {
        return followSymlinks ? NO_LINK_OPTION : NOFOLLOW_LINKS_OPTION;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Collection<String> getDirectoryEntries(PathFragment path) throws IOException {
        File file = this.getIoFile(path);
        String[] entries = null;
        long startTime = Profiler.nanoTimeMaybe();
        try {
            entries = file.list();
            if (entries == null) {
                if (file.exists()) {
                    throw new IOException(path + ERR_NOT_A_DIRECTORY);
                }
                throw new FileNotFoundException(path + ERR_NO_SUCH_FILE_OR_DIR);
            }
        }
        finally {
            profiler.logSimpleTask(startTime, ProfilerTask.VFS_DIR, file.getPath());
        }
        ArrayList<String> result = new ArrayList<String>(entries.length);
        for (String entry : entries) {
            if (entry.equals(".") || entry.equals("..")) continue;
            result.add(entry);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean exists(PathFragment path, boolean followSymlinks) {
        long startTime = Profiler.nanoTimeMaybe();
        try {
            Path nioPath = this.getNioPath(path);
            boolean bl = Files.exists(nioPath, this.linkOpts(followSymlinks));
            return bl;
        }
        catch (InvalidPathException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            profiler.logSimpleTask(startTime, ProfilerTask.VFS_STAT, path.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean isReadable(PathFragment path) throws IOException {
        File file = this.getIoFile(path);
        long startTime = Profiler.nanoTimeMaybe();
        try {
            if (!file.exists()) {
                throw new FileNotFoundException(path + ERR_NO_SUCH_FILE_OR_DIR);
            }
            boolean bl = file.canRead();
            return bl;
        }
        finally {
            profiler.logSimpleTask(startTime, ProfilerTask.VFS_STAT, file.getPath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean isWritable(PathFragment path) throws IOException {
        File file = this.getIoFile(path);
        long startTime = Profiler.nanoTimeMaybe();
        try {
            if (!file.exists()) {
                if (this.linkExists(file)) {
                    throw new IOException(path + " (Permission denied)");
                }
                throw new FileNotFoundException(path + ERR_NO_SUCH_FILE_OR_DIR);
            }
            boolean bl = file.canWrite();
            return bl;
        }
        finally {
            profiler.logSimpleTask(startTime, ProfilerTask.VFS_STAT, file.getPath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean isExecutable(PathFragment path) throws IOException {
        File file = this.getIoFile(path);
        long startTime = Profiler.nanoTimeMaybe();
        try {
            if (!file.exists()) {
                throw new FileNotFoundException(path + ERR_NO_SUCH_FILE_OR_DIR);
            }
            boolean bl = file.canExecute();
            return bl;
        }
        finally {
            profiler.logSimpleTask(startTime, ProfilerTask.VFS_STAT, file.getPath());
        }
    }

    @Override
    protected void setReadable(PathFragment path, boolean readable) throws IOException {
        File file = this.getIoFile(path);
        if (!file.exists()) {
            throw new FileNotFoundException(path + ERR_NO_SUCH_FILE_OR_DIR);
        }
        if (!file.setReadable(readable) && readable) {
            throw new IOException(String.format("Failed to make %s readable", path));
        }
    }

    @Override
    public void setWritable(PathFragment path, boolean writable) throws IOException {
        File file = this.getIoFile(path);
        if (!file.exists()) {
            throw new FileNotFoundException(path + ERR_NO_SUCH_FILE_OR_DIR);
        }
        if (!file.setWritable(writable) && writable) {
            throw new IOException(String.format("Failed to make %s writable", path));
        }
    }

    @Override
    protected void setExecutable(PathFragment path, boolean executable) throws IOException {
        File file = this.getIoFile(path);
        if (!file.exists()) {
            throw new FileNotFoundException(path + ERR_NO_SUCH_FILE_OR_DIR);
        }
        if (!file.setExecutable(executable) && executable) {
            throw new IOException(String.format("Failed to make %s executable", path));
        }
    }

    @Override
    public boolean supportsModifications(PathFragment path) {
        return true;
    }

    @Override
    public boolean supportsSymbolicLinksNatively(PathFragment path) {
        return true;
    }

    @Override
    public boolean supportsHardLinksNatively(PathFragment path) {
        return true;
    }

    @Override
    public boolean isFilePathCaseSensitive() {
        return true;
    }

    @Override
    public boolean createDirectory(PathFragment path) throws IOException {
        File file = this.getIoFile(path);
        if (file.mkdir()) {
            return true;
        }
        if (this.fileIsSymbolicLink(file)) {
            throw new IOException(path + ERR_FILE_EXISTS);
        }
        if (file.isDirectory()) {
            return false;
        }
        if (file.exists()) {
            throw new IOException(path + ERR_FILE_EXISTS);
        }
        if (!file.getParentFile().exists()) {
            throw new FileNotFoundException(path.getParentDirectory() + ERR_NO_SUCH_FILE_OR_DIR);
        }
        if (file.mkdir()) {
            return true;
        }
        if (!file.getParentFile().canWrite()) {
            throw new FileAccessException(path + " (Permission denied)");
        }
        throw new FileNotFoundException(path.getParentDirectory() + ERR_NOT_A_DIRECTORY);
    }

    @Override
    public void createDirectoryAndParents(PathFragment path) throws IOException {
        block2: {
            Path nioPath = this.getNioPath(path);
            try {
                Files.createDirectories(nioPath, new FileAttribute[0]);
            }
            catch (FileAlreadyExistsException e) {
                if (this.isDirectory(path, true)) break block2;
                throw e;
            }
        }
    }

    private boolean linkExists(File file) {
        String shortName = file.getName();
        File parentFile = file.getParentFile();
        if (parentFile == null) {
            return false;
        }
        String[] filenames = parentFile.list();
        if (filenames == null) {
            return false;
        }
        for (String name : filenames) {
            if (!name.equals(shortName)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void createSymbolicLink(PathFragment linkPath, PathFragment targetFragment) throws IOException {
        Path nioPath = this.getNioPath(linkPath);
        try {
            Files.createSymbolicLink(nioPath, Paths.get(targetFragment.getSafePathString(), new String[0]), new FileAttribute[0]);
        }
        catch (FileAlreadyExistsException e) {
            throw new IOException(linkPath + ERR_FILE_EXISTS, e);
        }
        catch (AccessDeniedException e) {
            throw new IOException(linkPath + " (Permission denied)", e);
        }
        catch (NoSuchFileException e) {
            throw new FileNotFoundException(linkPath + ERR_NO_SUCH_FILE_OR_DIR);
        }
    }

    @Override
    protected PathFragment readSymbolicLink(PathFragment path) throws IOException {
        Path nioPath = this.getNioPath(path);
        long startTime = Profiler.nanoTimeMaybe();
        try {
            String link = Files.readSymbolicLink(nioPath).toString();
            PathFragment pathFragment = PathFragment.create(link);
            return pathFragment;
        }
        catch (NotLinkException e) {
            throw new FileSystem.NotASymlinkException(path, (Throwable)e);
        }
        catch (NoSuchFileException e) {
            throw new FileNotFoundException(path + ERR_NO_SUCH_FILE_OR_DIR);
        }
        finally {
            profiler.logSimpleTask(startTime, ProfilerTask.VFS_READLINK, path.getPathString());
        }
    }

    @Override
    public void renameTo(PathFragment sourcePath, PathFragment targetPath) throws IOException {
        File targetFile;
        File sourceFile = this.getIoFile(sourcePath);
        if (!sourceFile.renameTo(targetFile = this.getIoFile(targetPath))) {
            if (!sourceFile.exists()) {
                throw new FileNotFoundException(sourcePath + ERR_NO_SUCH_FILE_OR_DIR);
            }
            if (targetFile.exists()) {
                if (targetFile.isDirectory() && targetFile.list().length > 0) {
                    throw new IOException(targetPath + ERR_DIRECTORY_NOT_EMPTY);
                }
                if (sourceFile.isDirectory() && targetFile.isFile()) {
                    throw new IOException(sourcePath + " -> " + targetPath + ERR_NOT_A_DIRECTORY);
                }
                if (sourceFile.isFile() && targetFile.isDirectory()) {
                    throw new IOException(sourcePath + " -> " + targetPath + ERR_IS_DIRECTORY);
                }
                throw new IOException(sourcePath + " -> " + targetPath + " (Permission denied)");
            }
            throw new FileAccessException(sourcePath + " -> " + targetPath + " (Permission denied)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected long getFileSize(PathFragment path, boolean followSymlinks) throws IOException {
        long startTime = Profiler.nanoTimeMaybe();
        try {
            long l = this.stat(path, followSymlinks).getSize();
            return l;
        }
        finally {
            profiler.logSimpleTask(startTime, ProfilerTask.VFS_STAT, path.getPathString());
        }
    }

    @Override
    protected boolean delete(PathFragment path) throws IOException {
        Path nioPath = this.getNioPath(path);
        long startTime = Profiler.nanoTimeMaybe();
        try {
            boolean bl = Files.deleteIfExists(nioPath);
            return bl;
        }
        catch (DirectoryNotEmptyException e) {
            throw new IOException(path.getPathString() + ERR_DIRECTORY_NOT_EMPTY, e);
        }
        catch (AccessDeniedException e) {
            throw new IOException(path.getPathString() + " (Permission denied)", e);
        }
        catch (AtomicMoveNotSupportedException | FileAlreadyExistsException | FileSystemLoopException | NoSuchFileException | NotDirectoryException | NotLinkException e) {
            throw new IOException(path.getPathString() + ": unexpected FileSystemException", e);
        }
        catch (FileSystemException e) {
            if (e.getClass().equals(FileSystemException.class) && !nioPath.getParent().toFile().isDirectory()) {
                boolean bl = false;
                return bl;
            }
            throw new IOException(path.getPathString() + ": unexpected FileSystemException", e);
        }
        finally {
            profiler.logSimpleTask(startTime, ProfilerTask.VFS_DELETE, path.getPathString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected long getLastModifiedTime(PathFragment path, boolean followSymlinks) throws IOException {
        File file = this.getIoFile(path);
        long startTime = Profiler.nanoTimeMaybe();
        try {
            long l = this.stat(path, followSymlinks).getLastModifiedTime();
            return l;
        }
        finally {
            profiler.logSimpleTask(startTime, ProfilerTask.VFS_STAT, file.getPath());
        }
    }

    protected boolean fileIsSymbolicLink(File file) {
        return Files.isSymbolicLink(file.toPath());
    }

    @Override
    public void setLastModifiedTime(PathFragment path, long newTime) throws IOException {
        File file = this.getIoFile(path);
        if (!file.setLastModified(newTime == -1L ? this.clock.currentTimeMillis() : newTime)) {
            if (!file.exists()) {
                throw new FileNotFoundException(path + ERR_NO_SUCH_FILE_OR_DIR);
            }
            if (!file.getParentFile().canWrite()) {
                throw new FileAccessException(path.getParentDirectory() + " (Permission denied)");
            }
            throw new FileAccessException(path + " (Permission denied)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected byte[] getDigest(PathFragment path) throws IOException {
        String name = path.toString();
        long startTime = Profiler.nanoTimeMaybe();
        try {
            byte[] byArray = super.getDigest(path);
            return byArray;
        }
        finally {
            profiler.logSimpleTask(startTime, ProfilerTask.VFS_MD5, name);
        }
    }

    @Override
    protected FileStatus stat(PathFragment path, boolean followSymlinks) throws IOException {
        BasicFileAttributes attributes;
        Path nioPath = this.getNioPath(path);
        try {
            attributes = Files.readAttributes(nioPath, BasicFileAttributes.class, this.linkOpts(followSymlinks));
        }
        catch (FileSystemException e) {
            throw new FileNotFoundException(path + ERR_NO_SUCH_FILE_OR_DIR);
        }
        FileStatus status = new FileStatus(){

            @Override
            public boolean isFile() {
                return attributes.isRegularFile() || this.isSpecialFile();
            }

            @Override
            public boolean isSpecialFile() {
                return attributes.isOther();
            }

            @Override
            public boolean isDirectory() {
                return attributes.isDirectory();
            }

            @Override
            public boolean isSymbolicLink() {
                return attributes.isSymbolicLink();
            }

            @Override
            public long getSize() {
                return attributes.size();
            }

            @Override
            public long getLastModifiedTime() {
                return attributes.lastModifiedTime().toMillis();
            }

            @Override
            public long getLastChangeTime() {
                return attributes.lastModifiedTime().toMillis();
            }

            @Override
            public long getNodeId() {
                return -1L;
            }
        };
        return status;
    }

    @Override
    @Nullable
    protected FileStatus statIfFound(PathFragment path, boolean followSymlinks) {
        try {
            return this.stat(path, followSymlinks);
        }
        catch (FileNotFoundException e) {
            return null;
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    protected void createFSDependentHardLink(PathFragment linkPath, PathFragment originalPath) throws IOException {
        Files.createLink(Paths.get(linkPath.toString(), new String[0]), Paths.get(originalPath.toString(), new String[0]));
    }
}

