/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.vfs;

import com.google.common.base.Preconditions;
import java.util.Objects;

public final class Dirent
implements Comparable<Dirent> {
    private final String name;
    private final Type type;

    public Dirent(String name, Type type) {
        this.name = Preconditions.checkNotNull(name);
        this.type = Preconditions.checkNotNull(type);
    }

    public String getName() {
        return this.name;
    }

    public Type getType() {
        return this.type;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.type});
    }

    public boolean equals(Object other) {
        if (!(other instanceof Dirent)) {
            return false;
        }
        if (this == other) {
            return true;
        }
        Dirent otherDirent = (Dirent)other;
        return this.name.equals(otherDirent.name) && this.type.equals((Object)otherDirent.type);
    }

    public String toString() {
        return this.name + "[" + this.type.toString().toLowerCase() + "]";
    }

    @Override
    public int compareTo(Dirent other) {
        return this.getName().compareTo(other.getName());
    }

    public static enum Type {
        FILE,
        DIRECTORY,
        SYMLINK,
        UNKNOWN;

    }
}

