/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.vfs;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.stats.CacheStats;
import com.google.common.base.Preconditions;
import com.google.common.primitives.Longs;
import com.google.devtools.build.lib.vfs.FileStatus;
import com.google.devtools.build.lib.vfs.Path;
import com.google.devtools.build.lib.vfs.PathFragment;
import com.google.devtools.build.lib.vfs.XattrProvider;
import java.io.IOException;

public class DigestUtils {
    public static final int ESTIMATED_SIZE = 32;
    private static Cache<CacheKey, byte[]> globalCache = null;

    private DigestUtils() {
    }

    public static void configureCache(long maximumSize) {
        globalCache = maximumSize == 0L ? null : Caffeine.newBuilder().maximumSize(maximumSize).recordStats().build();
    }

    public static CacheStats getCacheStats() {
        Cache<CacheKey, byte[]> cache = globalCache;
        Preconditions.checkNotNull(cache, "configureCache() must have been called with a size >= 0");
        return cache.stats();
    }

    public static byte[] getDigestWithManualFallback(Path path, long fileSize, XattrProvider xattrProvider) throws IOException {
        byte[] digest = xattrProvider.getFastDigest(path);
        return digest != null ? digest : DigestUtils.manuallyComputeDigest(path, fileSize);
    }

    public static byte[] getDigestWithManualFallbackWhenSizeUnknown(Path path, XattrProvider xattrProvider) throws IOException {
        return DigestUtils.getDigestWithManualFallback(path, -1L, xattrProvider);
    }

    public static byte[] manuallyComputeDigest(Path path, long fileSize) throws IOException {
        byte[] digest;
        Cache<CacheKey, byte[]> cache = globalCache;
        CacheKey key = null;
        if (cache != null && (digest = cache.getIfPresent(key = new CacheKey(path, path.stat()))) != null) {
            return digest;
        }
        digest = path.getDigest();
        Preconditions.checkNotNull(digest, "Missing digest for %s (size %s)", (Object)path, fileSize);
        if (cache != null) {
            cache.put(key, digest);
        }
        return digest;
    }

    public static byte[] xor(byte[] lhs, byte[] rhs) {
        int n = rhs.length;
        if (lhs.length >= n) {
            for (int i = 0; i < n; ++i) {
                int n2 = i;
                lhs[n2] = (byte)(lhs[n2] ^ rhs[i]);
            }
            return lhs;
        }
        return DigestUtils.xor(rhs, lhs);
    }

    private static class CacheKey {
        private final PathFragment path;
        private final long nodeId;
        private final long changeTime;
        private final long modifiedTime;
        private final long size;

        public CacheKey(Path path, FileStatus status) throws IOException {
            this.path = path.asFragment();
            this.nodeId = status.getNodeId();
            this.changeTime = status.getLastChangeTime();
            this.modifiedTime = status.getLastModifiedTime();
            this.size = status.getSize();
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof CacheKey)) {
                return false;
            }
            CacheKey key = (CacheKey)object;
            return this.path.equals(key.path) && this.nodeId == key.nodeId && this.changeTime == key.changeTime && this.modifiedTime == key.modifiedTime && this.size == key.size;
        }

        public int hashCode() {
            int result = 17;
            result = 31 * result + this.path.hashCode();
            result = 31 * result + Longs.hashCode(this.nodeId);
            result = 31 * result + Longs.hashCode(this.changeTime);
            result = 31 * result + Longs.hashCode(this.modifiedTime);
            result = 31 * result + Longs.hashCode(this.size);
            return result;
        }
    }
}

