/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.vfs;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import com.google.devtools.common.options.Converter;
import com.google.devtools.common.options.OptionsParsingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;

public class DigestHashFunction {
    private static final HashMap<String, DigestHashFunction> hashFunctionRegistry = new HashMap();
    public static final DigestHashFunction SHA1 = DigestHashFunction.register(Hashing.sha1(), "SHA-1", "SHA1");
    public static final DigestHashFunction SHA256 = DigestHashFunction.register(Hashing.sha256(), "SHA-256", "SHA256");
    private final HashFunction hashFunction;
    private final DigestLength digestLength;
    private final String name;
    private final MessageDigest messageDigestPrototype;
    private final boolean messageDigestPrototypeSupportsClone;
    private final ImmutableList<String> names;

    private DigestHashFunction(HashFunction hashFunction, DigestLength digestLength, ImmutableList<String> names) {
        this.hashFunction = hashFunction;
        this.digestLength = digestLength;
        Preconditions.checkArgument(!names.isEmpty());
        this.name = (String)names.get(0);
        this.names = names;
        this.messageDigestPrototype = this.getMessageDigestInstance();
        this.messageDigestPrototypeSupportsClone = DigestHashFunction.supportsClone(this.messageDigestPrototype);
    }

    public static DigestHashFunction register(HashFunction hash, String hashName, String ... altNames) {
        return DigestHashFunction.register(hash, new DigestLength.DigestLengthImpl(hash), hashName, altNames);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DigestHashFunction register(HashFunction hash, DigestLength digestLength, String hashName, String ... altNames) {
        try {
            MessageDigest.getInstance(hashName);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalArgumentException("The hash function name provided does not correspond to a valid MessageDigest: " + hashName, e);
        }
        ImmutableCollection names = ((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().add(hashName)).add(altNames)).build();
        DigestHashFunction hashFunction = new DigestHashFunction(hash, digestLength, (ImmutableList<String>)names);
        HashMap<String, DigestHashFunction> hashMap = hashFunctionRegistry;
        synchronized (hashMap) {
            for (String name : names) {
                if (hashFunctionRegistry.containsKey(name)) {
                    throw new IllegalArgumentException("Hash function " + name + " is already registered.");
                }
                hashFunctionRegistry.put(name, hashFunction);
            }
        }
        return hashFunction;
    }

    public HashFunction getHashFunction() {
        return this.hashFunction;
    }

    public MessageDigest cloneOrCreateMessageDigest() {
        if (this.messageDigestPrototypeSupportsClone) {
            try {
                return (MessageDigest)this.messageDigestPrototype.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new IllegalStateException("Could not clone message digest", e);
            }
        }
        return this.getMessageDigestInstance();
    }

    public DigestLength getDigestLength() {
        return this.digestLength;
    }

    public ImmutableList<String> getNames() {
        return this.names;
    }

    public String toString() {
        return this.name;
    }

    private MessageDigest getMessageDigestInstance() {
        try {
            return MessageDigest.getInstance(this.name);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("message digest " + this.name + " not available", e);
        }
    }

    private static boolean supportsClone(MessageDigest toCheck) {
        try {
            Object unused = toCheck.clone();
            return true;
        }
        catch (CloneNotSupportedException e) {
            return false;
        }
    }

    public static ImmutableSet<DigestHashFunction> getPossibleHashFunctions() {
        return ImmutableSet.copyOf(hashFunctionRegistry.values());
    }

    public static class DigestFunctionConverter
    extends Converter.Contextless<DigestHashFunction> {
        @Override
        public DigestHashFunction convert(String input) throws OptionsParsingException {
            for (Map.Entry<String, DigestHashFunction> possibleFunctions : hashFunctionRegistry.entrySet()) {
                if (!possibleFunctions.getKey().equalsIgnoreCase(input)) continue;
                return possibleFunctions.getValue();
            }
            throw new OptionsParsingException("Not a valid hash function.");
        }

        @Override
        public String getTypeDescription() {
            return "hash function";
        }
    }

    public static interface DigestLength {
        default public int getDigestLength(byte[] bytes, int offset) {
            return this.getDigestMaximumLength();
        }

        public int getDigestMaximumLength();

        public static class DigestLengthImpl
        implements DigestLength {
            private final int length;

            DigestLengthImpl(HashFunction hashFunction) {
                this.length = hashFunction.bits() / 8;
            }

            @Override
            public int getDigestMaximumLength() {
                return this.length;
            }
        }
    }
}

