/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.vfs;

import com.google.common.base.Preconditions;
import com.google.devtools.build.lib.vfs.Dirent;
import com.google.devtools.build.lib.vfs.FileStatus;
import com.google.devtools.build.lib.vfs.Path;
import com.google.devtools.build.lib.vfs.Symlinks;
import com.google.devtools.build.lib.vfs.SyscallCache;
import java.io.IOException;
import java.util.Collection;
import javax.annotation.Nullable;

public class DelegatingSyscallCache
implements SyscallCache {
    private SyscallCache delegate = SyscallCache.NO_CACHE;

    public void setDelegate(SyscallCache syscallCache) {
        this.delegate = Preconditions.checkNotNull(syscallCache);
    }

    @Override
    public Collection<Dirent> readdir(Path path) throws IOException {
        return this.delegate.readdir(path);
    }

    @Override
    @Nullable
    public FileStatus statIfFound(Path path, Symlinks symlinks) throws IOException {
        return this.delegate.statIfFound(path, symlinks);
    }

    @Override
    @Nullable
    public SyscallCache.DirentTypeWithSkip getType(Path path, Symlinks symlinks) throws IOException {
        return this.delegate.getType(path, symlinks);
    }

    @Override
    public byte[] getFastDigest(Path path) throws IOException {
        return this.delegate.getFastDigest(path);
    }

    @Override
    public byte[] getxattr(Path path, String xattrName) throws IOException {
        return this.delegate.getxattr(path, xattrName);
    }

    @Override
    public byte[] getxattr(Path path, String xattrName, Symlinks followSymlinks) throws IOException {
        return this.delegate.getxattr(path, xattrName, followSymlinks);
    }

    @Override
    public void noteAnalysisPhaseEnded() {
        this.delegate.noteAnalysisPhaseEnded();
    }

    @Override
    public void clear() {
        this.delegate.clear();
    }
}

