/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.vfs;

import com.google.devtools.build.lib.vfs.AbstractFileSystem;
import com.google.devtools.build.lib.vfs.DigestHashFunction;
import com.google.devtools.build.lib.vfs.FileStatus;
import com.google.devtools.build.lib.vfs.PathFragment;
import java.io.IOException;

public abstract class AbstractFileSystemWithCustomStat
extends AbstractFileSystem {
    public AbstractFileSystemWithCustomStat(DigestHashFunction hashFunction) {
        super(hashFunction);
    }

    @Override
    protected boolean isFile(PathFragment path, boolean followSymlinks) {
        FileStatus stat = this.statNullable(path, followSymlinks);
        return stat != null ? stat.isFile() : false;
    }

    @Override
    protected boolean isSpecialFile(PathFragment path, boolean followSymlinks) {
        FileStatus stat = this.statNullable(path, followSymlinks);
        return stat != null ? stat.isSpecialFile() : false;
    }

    @Override
    protected boolean isSymbolicLink(PathFragment path) {
        FileStatus stat = this.statNullable(path, false);
        return stat != null ? stat.isSymbolicLink() : false;
    }

    @Override
    protected boolean isDirectory(PathFragment path, boolean followSymlinks) {
        FileStatus stat = this.statNullable(path, followSymlinks);
        return stat != null ? stat.isDirectory() : false;
    }

    @Override
    protected abstract FileStatus stat(PathFragment var1, boolean var2) throws IOException;
}

