/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.vfs;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.devtools.build.lib.profiler.Profiler;
import com.google.devtools.build.lib.profiler.ProfilerTask;
import com.google.devtools.build.lib.vfs.DigestHashFunction;
import com.google.devtools.build.lib.vfs.FileAccessException;
import com.google.devtools.build.lib.vfs.FileStatus;
import com.google.devtools.build.lib.vfs.FileSystem;
import com.google.devtools.build.lib.vfs.PathFragment;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;

public abstract class AbstractFileSystem
extends FileSystem {
    protected static final String ERR_PERMISSION_DENIED = " (Permission denied)";
    protected static final Profiler profiler = Profiler.instance();
    private static final ImmutableSet<StandardOpenOption> READABLE_BYTE_CHANNEL_OPEN_OPTIONS = Sets.immutableEnumSet((Enum)StandardOpenOption.READ, (Enum[])new StandardOpenOption[0]);
    private static final ImmutableSet<ProfilerTask> READABLE_BYTE_CHANNEL_PROFILER_TASKS = Sets.immutableEnumSet((Enum)ProfilerTask.VFS_OPEN, (Enum[])new ProfilerTask[]{ProfilerTask.VFS_READ});
    private static final ImmutableSet<StandardOpenOption> READ_WRITE_BYTE_CHANNEL_OPEN_OPTIONS = Sets.immutableEnumSet((Enum)StandardOpenOption.READ, (Enum[])new StandardOpenOption[]{StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING});
    private static final ImmutableSet<ProfilerTask> READ_WRITE_BYTE_CHANNEL_PROFILER_TASKS = Sets.immutableEnumSet((Enum)ProfilerTask.VFS_OPEN, (Enum[])new ProfilerTask[]{ProfilerTask.VFS_READ, ProfilerTask.VFS_WRITE});

    public AbstractFileSystem(DigestHashFunction digestFunction) {
        super(digestFunction);
    }

    @Override
    protected InputStream getInputStream(PathFragment path) throws IOException {
        while (true) {
            try {
                return this.createMaybeProfiledInputStream(path);
            }
            catch (FileNotFoundException e) {
                if (e.getMessage().endsWith("(Interrupted system call)")) continue;
                throw e;
            }
            break;
        }
    }

    protected InputStream createFileInputStream(PathFragment path) throws IOException {
        return new FileInputStream(path.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InputStream createMaybeProfiledInputStream(PathFragment path) throws IOException {
        String name = path.toString();
        if (profiler.isActive() && (profiler.isProfiling(ProfilerTask.VFS_READ) || profiler.isProfiling(ProfilerTask.VFS_OPEN))) {
            long startTime = Profiler.nanoTimeMaybe();
            try {
                ProfiledInputStream profiledInputStream = new ProfiledInputStream(this.createFileInputStream(path), name);
                return profiledInputStream;
            }
            finally {
                profiler.logSimpleTask(startTime, ProfilerTask.VFS_OPEN, name);
            }
        }
        return this.createFileInputStream(path);
    }

    @Override
    protected ReadableByteChannel createReadableByteChannel(PathFragment path) throws IOException {
        return AbstractFileSystem.createSeekableByteChannelInternal(path, READABLE_BYTE_CHANNEL_OPEN_OPTIONS, READABLE_BYTE_CHANNEL_PROFILER_TASKS);
    }

    @Override
    protected SeekableByteChannel createReadWriteByteChannel(PathFragment path) throws IOException {
        return AbstractFileSystem.createSeekableByteChannelInternal(path, READ_WRITE_BYTE_CHANNEL_OPEN_OPTIONS, READ_WRITE_BYTE_CHANNEL_PROFILER_TASKS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static SeekableByteChannel createSeekableByteChannelInternal(PathFragment path, ImmutableSet<? extends OpenOption> options, ImmutableSet<ProfilerTask> profilerTasks) throws IOException {
        String name;
        block6: {
            block5: {
                name = path.getPathString();
                if (!profiler.isActive()) break block5;
                if (!profilerTasks.stream().noneMatch(profiler::isProfiling)) break block6;
            }
            return Files.newByteChannel(Paths.get(name, new String[0]), options, new FileAttribute[0]);
        }
        long startTime = Profiler.nanoTimeMaybe();
        try {
            SeekableByteChannel seekableByteChannel = Files.newByteChannel(Paths.get(name, new String[0]), options, new FileAttribute[0]);
            return seekableByteChannel;
        }
        finally {
            profiler.logSimpleTask(startTime, ProfilerTask.VFS_OPEN, name);
        }
    }

    @Override
    protected boolean createWritableDirectory(PathFragment path) throws IOException {
        FileStatus stat = this.statNullable(path, false);
        if (stat == null) {
            return this.createDirectory(path);
        }
        if (!stat.isDirectory()) {
            throw new IOException(path + " (Not a directory)");
        }
        this.chmod(path, 493);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected OutputStream createFileOutputStream(PathFragment path, boolean append, boolean internal) throws FileNotFoundException {
        String name = path.toString();
        if (!internal && profiler.isActive() && (profiler.isProfiling(ProfilerTask.VFS_WRITE) || profiler.isProfiling(ProfilerTask.VFS_OPEN))) {
            long startTime = Profiler.nanoTimeMaybe();
            try {
                ProfiledFileOutputStream profiledFileOutputStream = new ProfiledFileOutputStream(name, append);
                return profiledFileOutputStream;
            }
            finally {
                profiler.logSimpleTask(startTime, ProfilerTask.VFS_OPEN, name);
            }
        }
        return new FileOutputStream(name, append);
    }

    @Override
    protected OutputStream getOutputStream(PathFragment path, boolean append, boolean internal) throws IOException {
        try {
            return this.createFileOutputStream(path, append, internal);
        }
        catch (FileNotFoundException e) {
            if (e.getMessage().equals(path + ERR_PERMISSION_DENIED)) {
                throw new FileAccessException(e.getMessage());
            }
            throw e;
        }
    }

    @Override
    protected OutputStream getOutputStream(PathFragment path, boolean append) throws IOException {
        return this.getOutputStream(path, append, false);
    }

    private static final class ProfiledFileOutputStream
    extends FileOutputStream {
        private final String name;

        public ProfiledFileOutputStream(String name, boolean append) throws FileNotFoundException {
            super(name, append);
            this.name = name;
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.write(b, 0, b.length);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            long startTime = Profiler.nanoTimeMaybe();
            try {
                super.write(b, off, len);
            }
            finally {
                profiler.logSimpleTask(startTime, ProfilerTask.VFS_WRITE, this.name);
            }
        }
    }

    private static final class ProfiledInputStream
    extends FilterInputStream {
        private final InputStream impl;
        private final String name;

        public ProfiledInputStream(InputStream impl, String name) {
            super(impl);
            this.impl = impl;
            this.name = name;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int read() throws IOException {
            long startTime = Profiler.nanoTimeMaybe();
            try {
                int n = this.impl.read();
                return n;
            }
            finally {
                profiler.logSimpleTask(startTime, ProfilerTask.VFS_READ, this.name);
            }
        }

        @Override
        public int read(byte[] b) throws IOException {
            return this.read(b, 0, b.length);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            long startTime = Profiler.nanoTimeMaybe();
            try {
                int n = this.impl.read(b, off, len);
                return n;
            }
            finally {
                profiler.logSimpleTask(startTime, ProfilerTask.VFS_READ, this.name);
            }
        }
    }
}

