/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.util.io;

import com.google.common.base.Preconditions;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;

public class OutErr
implements Closeable {
    private final OutputStream out;
    private final OutputStream err;
    public static final OutErr SYSTEM_OUT_ERR = OutErr.create(System.out, System.err);

    public static OutErr create(OutputStream out, OutputStream err) {
        return new OutErr(out, err);
    }

    protected OutErr(OutputStream out, OutputStream err) {
        this.out = Preconditions.checkNotNull(out);
        this.err = Preconditions.checkNotNull(err);
    }

    @Override
    public void close() throws IOException {
        try {
            this.out.close();
        }
        finally {
            if (this.out != this.err) {
                this.err.close();
            }
        }
    }

    public final SystemPatcher getSystemPatcher() {
        return new SystemPatcher(this.out, this.err);
    }

    public static OutErr createSynchronizedFunnel(final OutputStream outputStream) {
        OutputStream syncOut = new OutputStream(){

            @Override
            public synchronized void write(int b) throws IOException {
                outputStream.write(b);
            }

            @Override
            public synchronized void write(byte[] b) throws IOException {
                outputStream.write(b);
            }

            @Override
            public synchronized void write(byte[] b, int off, int len) throws IOException {
                outputStream.write(b, off, len);
            }

            @Override
            public synchronized void flush() throws IOException {
                outputStream.flush();
            }

            @Override
            public synchronized void close() throws IOException {
                outputStream.close();
            }
        };
        return OutErr.create(syncOut, syncOut);
    }

    public OutputStream getOutputStream() {
        return this.out;
    }

    public OutputStream getErrorStream() {
        return this.err;
    }

    public void printOut(String s2) {
        PrintWriter writer = new PrintWriter(this.out, true);
        writer.print(s2);
        writer.flush();
    }

    public void printOutLn(String s2) {
        this.printOut(s2 + "\n");
    }

    public void printErr(String s2) {
        PrintWriter writer = new PrintWriter(this.err, true);
        writer.print(s2);
        writer.flush();
    }

    public void printErrLn(String s2) {
        this.printErr(s2 + "\n");
    }

    private static final class SwitchingPrintStream
    extends PrintStream {
        private SwitchingPrintStream(OutputStream override) {
            super(override, true);
        }

        private void switchBackTo(OutputStream saved) {
            this.out = saved;
        }
    }

    public static class SystemPatcher
    implements AutoCloseable {
        private final PrintStream savedOut = System.out;
        private final PrintStream savedErr = System.err;
        private final SwitchingPrintStream outPatch;
        private final SwitchingPrintStream errPatch;

        private SystemPatcher(OutputStream overrideOut, OutputStream overrideErr) {
            this.outPatch = new SwitchingPrintStream(overrideOut);
            this.errPatch = new SwitchingPrintStream(overrideErr);
        }

        public void start() {
            System.setOut(this.outPatch);
            System.setErr(this.errPatch);
        }

        @Override
        public void close() {
            System.setOut(this.savedOut);
            System.setErr(this.savedErr);
            this.outPatch.switchBackTo(this.savedOut);
            this.errPatch.switchBackTo(this.savedErr);
        }
    }
}

