/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.util.io;

import com.google.devtools.build.lib.util.io.LineFlushingOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;

public final class LinePrefixingOutputStream
extends LineFlushingOutputStream {
    private byte[] linePrefix;
    private final OutputStream sink;

    public LinePrefixingOutputStream(String linePrefix, OutputStream sink) {
        this.linePrefix = linePrefix.getBytes(StandardCharsets.UTF_8);
        this.sink = sink;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void flushingHook() throws IOException {
        OutputStream outputStream = this.sink;
        synchronized (outputStream) {
            if (this.len == 0) {
                this.sink.flush();
                return;
            }
            byte lastByte = this.buffer[this.len - 1];
            boolean lineIsIncomplete = lastByte != NEWLINE;
            this.sink.write(this.linePrefix);
            this.sink.write(this.buffer, 0, this.len);
            if (lineIsIncomplete) {
                this.sink.write(NEWLINE);
            }
            this.sink.flush();
            this.len = 0;
        }
    }
}

