/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.util.io;

import java.io.IOException;
import java.io.OutputStream;

abstract class LineFlushingOutputStream
extends OutputStream {
    static final int BUFFER_LENGTH = 8192;
    protected static byte NEWLINE = (byte)10;
    protected final byte[] buffer = new byte[8192];
    protected int len = 0;

    LineFlushingOutputStream() {
    }

    @Override
    public synchronized void write(byte[] b, int off, int inlen) throws IOException {
        if (this.len == 8192) {
            this.flush();
        }
        int charsInLine = 0;
        while (inlen > charsInLine) {
            boolean sawNewline = b[off + charsInLine] == NEWLINE;
            if (!sawNewline && this.len + ++charsInLine != 8192) continue;
            System.arraycopy(b, off, this.buffer, this.len, charsInLine);
            this.len += charsInLine;
            off += charsInLine;
            inlen -= charsInLine;
            this.flush();
            charsInLine = 0;
        }
        System.arraycopy(b, off, this.buffer, this.len, charsInLine);
        this.len += charsInLine;
    }

    @Override
    public void write(int byteAsInt) throws IOException {
        byte b = (byte)byteAsInt;
        this.write(new byte[]{b}, 0, 1);
    }

    @Override
    public synchronized void close() throws IOException {
        this.flush();
    }

    @Override
    public final synchronized void flush() throws IOException {
        this.flushingHook();
    }

    protected abstract void flushingHook() throws IOException;
}

