/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.util;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.flogger.GoogleLogger;
import com.google.devtools.build.lib.bugreport.BugReporter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class ThreadUtils {
    private static final GoogleLogger logger = GoogleLogger.forEnclosingClass();
    private static final Comparator<Map.Entry<StackTraceAndState, ArrayList<Map.Entry<Thread, StackTraceElement[]>>>> STACK_SIZE_THEN_THREAD_COUNT_BOTH_DESCENDING_COMPARATOR = Map.Entry.comparingByKey().thenComparingInt(o -> ((ArrayList)o.getValue()).size()).reversed();
    private static final Collector<Map.Entry<Thread, StackTraceElement[]>, ?, Map<StackTraceAndState, ArrayList<Map.Entry<Thread, StackTraceElement[]>>>> MAP_WITH_ARRAY_LIST_VALUES_COLLECTOR = Collectors.groupingBy(StackTraceAndState::new, Collectors.toCollection(ArrayList::new));
    private static final Comparator<Map.Entry<Thread, StackTraceElement[]>> THREAD_NAME_THEN_ID = Comparator.comparing(o -> ((Thread)o.getKey()).getName()).thenComparingLong(o -> ((Thread)o.getKey()).getId());

    private ThreadUtils() {
    }

    public static synchronized void warnAboutSlowInterrupt(@Nullable String slowInterruptMessageSuffix) {
        ThreadUtils.warnAboutSlowInterrupt(slowInterruptMessageSuffix, BugReporter.defaultInstance());
    }

    @VisibleForTesting
    static synchronized void warnAboutSlowInterrupt(@Nullable String slowInterruptMessageSuffix, BugReporter bugReporter) {
        ((GoogleLogger.Api)logger.atWarning()).log("Interrupt took too long. Dumping thread state.");
        AtomicReference firstTrace = new AtomicReference();
        Thread.getAllStackTraces().entrySet().stream().collect(MAP_WITH_ARRAY_LIST_VALUES_COLLECTOR).entrySet().stream().sorted(STACK_SIZE_THEN_THREAD_COUNT_BOTH_DESCENDING_COMPARATOR).forEach(e -> {
            StackTraceAndState stackTraceAndState = (StackTraceAndState)e.getKey();
            if (!(firstTrace.get() != null || stackTraceAndState.trace[0].getClassName().endsWith("misc.Unsafe") && stackTraceAndState.trace[0].getMethodName().equals("park") || stackTraceAndState.trace[0].getClassName().endsWith("java.lang.Object") && stackTraceAndState.trace[0].getMethodName().equals("wait"))) {
                firstTrace.compareAndSet(null, stackTraceAndState);
            }
            ((GoogleLogger.Api)logger.atWarning()).log("%s %s%s", (Object)stackTraceAndState.state, ThreadUtils.makeThreadInfoString((ArrayList)e.getValue()), ThreadUtils.makeString(stackTraceAndState.trace));
        });
        SlowInterruptInnerException inner = new SlowInterruptInnerException(Joiner.on(' ').skipNulls().join("(Wrapper exception for longest stack trace)", slowInterruptMessageSuffix, new Object[0]));
        inner.setStackTrace(((StackTraceAndState)firstTrace.get()).trace);
        SlowInterruptException ex = new SlowInterruptException(inner);
        bugReporter.sendBugReport(ex);
    }

    private static String makeString(StackTraceElement[] stackTrace) {
        StringBuilder builder = new StringBuilder();
        for (StackTraceElement elt : stackTrace) {
            builder.append('\n').append('\t').append(elt);
        }
        return builder.toString();
    }

    private static String makeThreadInfoString(ArrayList<Map.Entry<Thread, StackTraceElement[]>> entries) {
        StringBuilder builder = new StringBuilder();
        if (entries.size() > 10) {
            builder.append(entries.size()).append(" threads, ");
        }
        entries.sort(THREAD_NAME_THEN_ID);
        boolean first = true;
        for (Map.Entry<Thread, StackTraceElement[]> entry : entries) {
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            Thread thread = entry.getKey();
            builder.append('<').append(thread.getName()).append(' ').append(thread.getId()).append('>');
        }
        return builder.toString();
    }

    private static class SlowInterruptInnerException
    extends Exception {
        SlowInterruptInnerException(String message) {
            super(message);
        }
    }

    private static final class StackTraceAndState
    implements Comparable<StackTraceAndState> {
        private final StackTraceElement[] trace;
        private final Thread.State state;

        StackTraceAndState(Map.Entry<Thread, StackTraceElement[]> threadEntry) {
            this.trace = threadEntry.getValue();
            this.state = threadEntry.getKey().getState();
        }

        public int hashCode() {
            return 31 * this.state.hashCode() + Arrays.hashCode(this.trace);
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof StackTraceAndState)) {
                return false;
            }
            StackTraceAndState that = (StackTraceAndState)obj;
            return Arrays.equals(this.trace, that.trace) && this.state.equals((Object)that.state);
        }

        @Override
        public int compareTo(StackTraceAndState o) {
            return Integer.compare(this.trace.length, o.trace.length);
        }
    }

    private static final class SlowInterruptException
    extends RuntimeException {
        public SlowInterruptException(SlowInterruptInnerException inner) {
            super("Slow interrupt", inner);
        }
    }
}

