/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.util;

public enum TestType {
    PRODUCTION(false),
    UNKNOWN_TEST(true),
    JAVA_INTEGRATION(true),
    SHELL_INTEGRATION(true);

    private static final TestType TEST_TYPE;
    private final boolean inTest;

    private TestType(boolean inTest) {
        this.inTest = inTest;
    }

    private static TestType getTestTypeFromEnvVars() {
        boolean inShellIntegrationTest;
        boolean inTest = System.getenv("TEST_TMPDIR") != null;
        boolean bl = inShellIntegrationTest = System.getenv("BAZEL_SHELL_TEST") != null;
        return inShellIntegrationTest ? SHELL_INTEGRATION : (inTest ? UNKNOWN_TEST : PRODUCTION);
    }

    public static TestType getTestType() {
        return TEST_TYPE;
    }

    public static boolean isInTest() {
        return TestType.getTestType().inTest();
    }

    public boolean inTest() {
        return this.inTest;
    }

    static {
        TEST_TYPE = TestType.getTestTypeFromEnvVars();
    }
}

