/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.util;

import com.google.common.base.Joiner;
import com.google.common.escape.CharEscaperBuilder;
import com.google.common.escape.Escaper;
import java.util.Collection;

public class StringUtilities {
    private static final Joiner NEWLINE_JOINER = Joiner.on('\n');
    private static final Escaper CONTROL_CHAR_ESCAPER = new CharEscaperBuilder().addEscape('\r', "\\r").addEscapes(new char[]{'\u0000', '\u0001', '\u0002', '\u0003', '\u0004', '\u0005', '\u0006', '\u0007', '\b', '\t', '\n', '\u000b', '\f', '\u000e', '\u000f', '\u0010', '\u0011', '\u0012', '\u0013', '\u0014', '\u0015', '\u0016', '\u0017', '\u0018', '\u0019', '\u001a', '\u001b', '\u001c', '\u001d', '\u001e', '\u001f', '\u007f'}, "<?>").toEscaper();

    private StringUtilities() {
    }

    public static String joinLines(String ... lines) {
        return NEWLINE_JOINER.join(lines);
    }

    public static String joinLines(Collection<String> lines) {
        return NEWLINE_JOINER.join(lines);
    }

    public static String replaceAllLiteral(String input, String literal, String replacement) {
        int literalLength = literal.length();
        if (literalLength == 0) {
            return input;
        }
        StringBuilder result = new StringBuilder(input.length() + replacement.length());
        int start = 0;
        int index = 0;
        while ((index = input.indexOf(literal, start)) >= 0) {
            result.append(input, start, index);
            result.append(replacement);
            start = index + literalLength;
        }
        result.append(input.substring(start));
        return result.toString();
    }

    public static String prettyPrintBytes(long bytes) {
        if ((double)bytes < 10000.0) {
            return bytes + "B";
        }
        if ((double)bytes < 1.0E7) {
            return (int)((double)bytes / 1000.0) + "KB";
        }
        if ((double)bytes < 1.0E11) {
            return (int)((double)bytes / 1000000.0) + "MB";
        }
        return (int)((double)bytes / 1.0E9) + "GB";
    }

    public static String sanitizeControlChars(String message) {
        return CONTROL_CHAR_ESCAPER.escape(message);
    }
}

