/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.util;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Iterator;

public class StringUtil {
    public static String joinEnglishList(Iterable<?> choices) {
        return StringUtil.joinEnglishList(choices, "or", "");
    }

    public static String joinEnglishList(Iterable<?> choices, String lastSeparator) {
        return StringUtil.joinEnglishList(choices, lastSeparator, "");
    }

    public static String joinEnglishList(Iterable<?> choices, String lastSeparator, String quote) {
        StringBuilder buf = new StringBuilder();
        Iterator<?> ii = choices.iterator();
        while (ii.hasNext()) {
            Object choice = ii.next();
            if (buf.length() > 0) {
                buf.append((String)(ii.hasNext() ? "," : " " + lastSeparator));
                buf.append(" ");
            }
            buf.append(quote).append(choice).append(quote);
        }
        return buf.length() == 0 ? "nothing" : buf.toString();
    }

    public static StringBuilder listItemsWithLimit(StringBuilder appendTo, int limit, Collection<?> items) {
        Preconditions.checkState(limit > 0);
        Joiner.on(", ").appendTo(appendTo, Iterables.limit(items, limit));
        if (items.size() > limit) {
            appendTo.append(" ...(omitting ").append(items.size() - limit).append(" more item(s))");
        }
        return appendTo;
    }

    public static String ordinal(int number) {
        switch (number) {
            case 1: {
                return "1st";
            }
            case 2: {
                return "2nd";
            }
            case 3: {
                return "3rd";
            }
        }
        return number + "th";
    }

    public static String decodeBytestringUtf8(String maybeUtf8) {
        if (maybeUtf8.chars().allMatch(c -> c < 128)) {
            return maybeUtf8;
        }
        if (maybeUtf8.chars().anyMatch(c -> c > 255)) {
            return maybeUtf8;
        }
        byte[] utf8 = maybeUtf8.getBytes(StandardCharsets.ISO_8859_1);
        String decoded = new String(utf8, StandardCharsets.UTF_8);
        if (decoded.chars().anyMatch(c -> c == 65533)) {
            return maybeUtf8;
        }
        return decoded;
    }

    public static String encodeBytestringUtf8(String unicode) {
        if (unicode.chars().allMatch(c -> c < 128)) {
            return unicode;
        }
        byte[] utf8 = unicode.getBytes(StandardCharsets.UTF_8);
        return new String(utf8, StandardCharsets.ISO_8859_1);
    }
}

