/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.util;

import com.google.common.base.CharMatcher;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.Iterables;
import com.google.common.escape.CharEscaperBuilder;
import com.google.common.escape.Escaper;
import java.io.IOException;

public final class ShellEscaper
extends Escaper {
    public static final ShellEscaper INSTANCE = new ShellEscaper();
    private static final Function<String, String> AS_FUNCTION = INSTANCE.asFunction();
    private static final Joiner SPACE_JOINER = Joiner.on(' ');
    private static final Escaper STRONGQUOTE_ESCAPER = new CharEscaperBuilder().addEscape('\'', "'\\''").toEscaper();
    private static final CharMatcher SAFECHAR_MATCHER = CharMatcher.anyOf("@%-_+:,./").or(CharMatcher.inRange('0', '9')).or(CharMatcher.inRange('a', 'z')).or(CharMatcher.inRange('A', 'Z')).precomputed();
    private static final CharMatcher SAFECHAR_MATCHER_WITH_TILDE = SAFECHAR_MATCHER.or(CharMatcher.is('~')).precomputed();

    @Override
    public String escape(String unescaped) {
        String s2 = unescaped.toString();
        if (s2.isEmpty()) {
            return "''";
        }
        if (SAFECHAR_MATCHER.matchesAllOf(s2)) {
            return s2;
        }
        if (SAFECHAR_MATCHER_WITH_TILDE.matchesAllOf(s2) && s2.charAt(0) != '~') {
            return s2;
        }
        return "'" + STRONGQUOTE_ESCAPER.escape(s2) + "'";
    }

    public static String escapeString(String unescaped) {
        return INSTANCE.escape(unescaped);
    }

    public static Iterable<String> escapeAll(Iterable<? extends String> unescaped) {
        return Iterables.transform(unescaped, AS_FUNCTION);
    }

    public static Appendable escapeJoinAll(Appendable out, Iterable<? extends String> argv) throws IOException {
        return SPACE_JOINER.appendTo(out, ShellEscaper.escapeAll(argv));
    }

    public static Appendable escapeJoinAll(Appendable out, Iterable<? extends String> argv, Joiner joiner) throws IOException {
        return joiner.appendTo(out, ShellEscaper.escapeAll(argv));
    }

    public static String escapeJoinAll(Iterable<? extends String> argv) {
        return SPACE_JOINER.join(ShellEscaper.escapeAll(argv));
    }

    public static String escapeJoinAll(Iterable<? extends String> argv, Joiner joiner) {
        return joiner.join(ShellEscaper.escapeAll(argv));
    }

    private ShellEscaper() {
    }
}

