/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.util;

import com.google.common.base.CharMatcher;
import com.google.common.base.Splitter;
import com.google.common.io.Files;
import com.google.devtools.build.lib.unix.ProcMeminfoParser;
import com.sun.management.OperatingSystemMXBean;
import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class ResourceUsage {
    private static final OperatingSystemMXBean OS_BEAN = (OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean();
    private static final MemoryMXBean MEM_BEAN = ManagementFactory.getMemoryMXBean();
    private static final Splitter WHITESPACE_SPLITTER = Splitter.on(CharMatcher.whitespace());
    private static final Pattern PSI_AVG10_VALUE_PATTERN = Pattern.compile("^full avg10=([\\d.]+).*");

    private ResourceUsage() {
    }

    public static int getAvailableProcessors() {
        return OS_BEAN.getAvailableProcessors();
    }

    public static long getTotalPhysicalMemorySize() {
        return OS_BEAN.getTotalPhysicalMemorySize();
    }

    public static String getOsArchitecture() {
        return OS_BEAN.getArch();
    }

    public static String getOsName() {
        return OS_BEAN.getName();
    }

    public static String getOsVersion() {
        return OS_BEAN.getVersion();
    }

    public static long getHeapMemoryInit() {
        return MEM_BEAN.getHeapMemoryUsage().getInit();
    }

    public static long getNonHeapMemoryInit() {
        return MEM_BEAN.getNonHeapMemoryUsage().getInit();
    }

    public static long getHeapMemoryMax() {
        return MEM_BEAN.getHeapMemoryUsage().getMax();
    }

    public static long getNonHeapMemoryMax() {
        return MEM_BEAN.getNonHeapMemoryUsage().getMax();
    }

    public static Measurement measureCurrentResourceUsage() {
        return new Measurement(MEM_BEAN.getHeapMemoryUsage().getUsed(), MEM_BEAN.getHeapMemoryUsage().getCommitted(), MEM_BEAN.getNonHeapMemoryUsage().getUsed(), MEM_BEAN.getNonHeapMemoryUsage().getCommitted(), (float)OS_BEAN.getSystemLoadAverage(), ResourceUsage.readPressureStallIndicator("memory"), ResourceUsage.readPressureStallIndicator("io"), ResourceUsage.getAvailableMemory(), ResourceUsage.getCurrentCpuUtilizationInMs());
    }

    private static long[] getCurrentCpuUtilizationInMs() {
        try {
            File file = new File("/proc/self/stat");
            if (file.isDirectory() || !file.canRead()) {
                return new long[2];
            }
            List<String> stat = WHITESPACE_SPLITTER.splitToList(Files.asCharSource(file, StandardCharsets.US_ASCII).read());
            if (stat.size() < 15) {
                return new long[2];
            }
            return new long[]{Long.parseLong(stat.get(13)) * 10L, Long.parseLong(stat.get(14)) * 10L};
        }
        catch (IOException | NumberFormatException e) {
            return new long[2];
        }
    }

    public static float readPressureStallIndicator(String type) {
        String fileName = "/proc/pressure/" + type;
        File procFile = new File(fileName);
        if (!procFile.canRead()) {
            return -1.0f;
        }
        try {
            List<String> lines = Files.readLines(procFile, Charset.defaultCharset());
            for (String l : lines) {
                if (!l.startsWith("full avg10")) continue;
                Matcher matcher = PSI_AVG10_VALUE_PATTERN.matcher(l);
                if (!matcher.matches()) {
                    return -1.0f;
                }
                return Float.parseFloat(matcher.group(1));
            }
            return -1.0f;
        }
        catch (IOException e) {
            return -1.0f;
        }
    }

    public static long getAvailableMemory() {
        long availableMemory;
        try {
            ProcMeminfoParser meminfo = new ProcMeminfoParser();
            availableMemory = meminfo.getFreeRamKb() << 10;
        }
        catch (IOException e) {
            availableMemory = OS_BEAN.getFreePhysicalMemorySize();
        }
        return availableMemory;
    }

    public static final class Measurement {
        private final long timeInNanos = System.nanoTime();
        private final long heapMemoryUsed;
        private final long heapMemoryCommitted;
        private final long nonHeapMemoryUsed;
        private final long nonHeapMemoryCommitted;
        private final float loadAverageLastMinute;
        private final float memoryPressureLast10Sec;
        private final float ioPressureLast10Sec;
        private final long freePhysicalMemory;
        private final long[] cpuUtilizationInMs;

        public Measurement(long heapMemoryUsed, long heapMemoryCommitted, long nonHeapMemoryUsed, long nonHeapMemoryCommitted, float loadAverageLastMinute, float memoryPressureLast10Sec1, float ioPressureLast10Sec1, long freePhysicalMemory, long[] cpuUtilizationInMs) {
            this.heapMemoryUsed = heapMemoryUsed;
            this.heapMemoryCommitted = heapMemoryCommitted;
            this.nonHeapMemoryUsed = nonHeapMemoryUsed;
            this.nonHeapMemoryCommitted = nonHeapMemoryCommitted;
            this.loadAverageLastMinute = loadAverageLastMinute;
            this.memoryPressureLast10Sec = memoryPressureLast10Sec1;
            this.ioPressureLast10Sec = ioPressureLast10Sec1;
            this.freePhysicalMemory = freePhysicalMemory;
            this.cpuUtilizationInMs = cpuUtilizationInMs;
        }

        public long getTimeInMs() {
            return this.timeInNanos / 1000000L;
        }

        public long getHeapMemoryUsed() {
            return this.heapMemoryUsed;
        }

        public long getHeapMemoryCommitted() {
            return this.heapMemoryCommitted;
        }

        public long getNonHeapMemoryUsed() {
            return this.nonHeapMemoryUsed;
        }

        public long getNonHeapMemoryCommitted() {
            return this.nonHeapMemoryCommitted;
        }

        public float getLoadAverageLastMinute() {
            return this.loadAverageLastMinute;
        }

        public float getMemoryPressureLast10Sec() {
            return this.memoryPressureLast10Sec;
        }

        public float getIoPressureLast10Sec() {
            return this.ioPressureLast10Sec;
        }

        public long getFreePhysicalMemory() {
            return this.freePhysicalMemory;
        }

        public long[] getCpuUtilizationInMs() {
            return new long[]{this.cpuUtilizationInMs[0], this.cpuUtilizationInMs[1]};
        }
    }
}

