/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.util;

import com.google.common.io.ByteStreams;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;

public final class ResourceFileLoader {
    private ResourceFileLoader() {
    }

    public static boolean resourceExists(Class<?> relativeToClass, String resourceName) {
        boolean bl;
        block8: {
            InputStream resourceStream = ResourceFileLoader.getResourceAsStream(relativeToClass, resourceName);
            try {
                boolean bl2 = bl = resourceStream != null;
                if (resourceStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (resourceStream != null) {
                        try {
                            resourceStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    return false;
                }
            }
            resourceStream.close();
        }
        return bl;
    }

    public static String loadResource(Class<?> relativeToClass, String resourceName) throws IOException {
        try (InputStream stream = ResourceFileLoader.getResourceAsStream(relativeToClass, resourceName);){
            if (stream == null) {
                throw new IOException(resourceName + " not found.");
            }
            String string = new String(ByteStreams.toByteArray(stream), StandardCharsets.UTF_8);
            return string;
        }
    }

    private static InputStream getResourceAsStream(Class<?> relativeToClass, String resourceName) {
        ClassLoader loader = relativeToClass.getClassLoader();
        String resource = ResourceFileLoader.resolveResource(relativeToClass, resourceName);
        return loader.getResourceAsStream(resource);
    }

    public static String resolveResource(Class<?> relativeToClass, String resourceName) {
        String className = relativeToClass.getName();
        String packageName = className.substring(0, className.lastIndexOf(46));
        String path = packageName.replace('.', '/');
        return path + "/" + resourceName;
    }
}

