/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.util;

import com.google.common.base.Joiner;
import com.google.devtools.common.options.Converter;
import com.google.devtools.common.options.OptionsParsingException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.TreeSet;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.annotation.Nullable;

public final class RegexFilter
implements Predicate<String> {
    @Nullable
    private final Pattern inclusionPattern;
    @Nullable
    private final Pattern exclusionPattern;
    private final int hashCode;

    private RegexFilter(@Nullable Pattern inclusionPattern, @Nullable Pattern exclusionPattern) {
        this.inclusionPattern = inclusionPattern;
        this.exclusionPattern = exclusionPattern;
        this.hashCode = Objects.hash(inclusionPattern == null ? null : inclusionPattern.pattern(), exclusionPattern == null ? null : exclusionPattern.pattern());
    }

    public RegexFilter(List<String> inclusions, List<String> exclusions) {
        this(RegexFilter.takeUnionOfRegexes(inclusions), RegexFilter.takeUnionOfRegexes(exclusions));
    }

    @Nullable
    private static Pattern takeUnionOfRegexes(List<String> regexList) {
        if (regexList.isEmpty()) {
            return null;
        }
        TreeSet<String> deduped = new TreeSet<String>(regexList);
        return Pattern.compile("(?:(?>" + Joiner.on(")|(?>").join(deduped) + "))");
    }

    public boolean isIncluded(String value) {
        if (this.exclusionPattern != null && this.exclusionPattern.matcher(value).find()) {
            return false;
        }
        if (this.inclusionPattern == null) {
            return true;
        }
        return this.inclusionPattern.matcher(value).find();
    }

    @Override
    public boolean test(String value) {
        return this.isIncluded(value);
    }

    @Nullable
    public String getInclusionRegex() {
        return this.inclusionPattern == null ? null : this.inclusionPattern.pattern();
    }

    @Nullable
    public String getExclusionRegex() {
        return this.exclusionPattern == null ? null : this.exclusionPattern.pattern();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (this.inclusionPattern != null) {
            builder.append(this.inclusionPattern.pattern().replace(",", "\\,"));
            if (this.exclusionPattern != null) {
                builder.append(",");
            }
        }
        if (this.exclusionPattern != null) {
            builder.append("-");
            builder.append(this.exclusionPattern.pattern().replace(",", "\\,"));
        }
        return builder.toString();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof RegexFilter)) {
            return false;
        }
        RegexFilter otherFilter = (RegexFilter)other;
        if (this.exclusionPattern == null ^ otherFilter.exclusionPattern == null) {
            return false;
        }
        if (this.inclusionPattern == null ^ otherFilter.inclusionPattern == null) {
            return false;
        }
        if (this.exclusionPattern != null && !this.exclusionPattern.pattern().equals(otherFilter.exclusionPattern.pattern())) {
            return false;
        }
        return this.inclusionPattern == null || this.inclusionPattern.pattern().equals(otherFilter.inclusionPattern.pattern());
    }

    public int hashCode() {
        return this.hashCode;
    }

    public static class RegexFilterConverter
    extends Converter.Contextless<RegexFilter> {
        @Override
        public RegexFilter convert(String input) throws OptionsParsingException {
            ArrayList<String> inclusionList = new ArrayList<String>();
            ArrayList<String> exclusionList = new ArrayList<String>();
            for (String piece : input.split("(?<!\\\\),")) {
                boolean isExcluded = (piece = piece.replace("\\,", ",")).startsWith("-");
                if (isExcluded || piece.startsWith("+")) {
                    piece = piece.substring(1);
                }
                if (piece.length() <= 0) continue;
                (isExcluded ? exclusionList : inclusionList).add(piece);
            }
            try {
                return new RegexFilter(inclusionList, exclusionList);
            }
            catch (PatternSyntaxException e) {
                throw new OptionsParsingException("Failed to build valid regular expression: " + e.getMessage());
            }
        }

        @Override
        public String getTypeDescription() {
            return "a comma-separated list of regex expressions with prefix '-' specifying excluded paths";
        }
    }
}

