/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.util;

import com.google.common.base.Preconditions;
import com.google.common.collect.ForwardingMap;
import com.google.common.collect.Sets;
import com.google.common.flogger.GoogleLogger;
import com.google.common.io.ByteStreams;
import com.google.devtools.build.lib.vfs.FileSystemUtils;
import com.google.devtools.build.lib.vfs.Path;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.LinkedBlockingQueue;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;

public abstract class PersistentMap<K, V>
extends ForwardingMap<K, V> {
    private static final int MAGIC = 537334021;
    private static final int ENTRY_MAGIC = 254;
    private static final int MIN_MAPFILE_SIZE = 16;
    private static final int MAX_ARRAY_SIZE = 0x7FFFFFF7;
    private static final GoogleLogger logger = GoogleLogger.forEnclosingClass();
    private final int version;
    @GuardedBy(value="this")
    private final Path mapFile;
    @GuardedBy(value="this")
    private final Path journalFile;
    private final LinkedBlockingQueue<K> journal;
    private DataOutputStream journalOut;
    private boolean dirty;
    private String deferredIOFailure = null;
    private boolean loaded;
    private final ConcurrentMap<K, V> delegate;

    public PersistentMap(int version, ConcurrentMap<K, V> map, Path mapFile, Path journalFile) {
        this.version = version;
        this.journal = new LinkedBlockingQueue();
        this.mapFile = mapFile;
        this.journalFile = journalFile;
        this.delegate = map;
    }

    @Override
    protected Map<K, V> delegate() {
        return this.delegate;
    }

    @Override
    @Nullable
    public V put(K key, V value) {
        V previous = this.delegate().put(Preconditions.checkNotNull(key, value), Preconditions.checkNotNull(value, key));
        this.journal.add(key);
        this.markAsDirty();
        return previous;
    }

    protected void markAsDirty() {
        this.dirty = true;
        if (this.updateJournal()) {
            this.writeJournal();
        }
    }

    protected boolean updateJournal() {
        return true;
    }

    @Override
    @Nullable
    public V remove(Object object) {
        Object previous = this.delegate().remove(object);
        if (previous != null) {
            this.journal.add(object);
            this.markAsDirty();
        }
        return previous;
    }

    private synchronized void writeJournal() {
        try {
            if (this.journalOut == null) {
                this.journalOut = this.journalFile.exists() ? new DataOutputStream(new BufferedOutputStream(this.journalFile.getOutputStream(true))) : this.createMapFile(this.journalFile);
            }
            LinkedHashSet items = Sets.newLinkedHashSetWithExpectedSize(this.journal.size());
            this.journal.drainTo(items);
            this.writeEntries(this.journalOut, items, (Map<K, V>)this.delegate());
            this.journalOut.flush();
        }
        catch (IOException e) {
            this.deferredIOFailure = e.getMessage() + " during journal append";
        }
    }

    protected void forceFlush() {
        if (this.dirty) {
            this.writeJournal();
        }
    }

    public synchronized void load(boolean failFast) throws IOException {
        if (!this.loaded) {
            this.loadEntries(this.mapFile, failFast);
            if (this.journalFile.exists()) {
                block5: {
                    try {
                        this.loadEntries(this.journalFile, failFast);
                    }
                    catch (IOException e) {
                        if (!failFast) break block5;
                        throw e;
                    }
                }
                this.dirty = true;
                this.save(true);
            } else {
                this.dirty = false;
            }
            this.loaded = true;
        }
    }

    public synchronized void load() throws IOException {
        this.load(false);
    }

    @Override
    public synchronized void clear() {
        super.clear();
        this.markAsDirty();
        try {
            this.save();
        }
        catch (IOException e) {
            this.deferredIOFailure = e.getMessage() + " during map write";
        }
    }

    public synchronized long save() throws IOException {
        return this.save(false);
    }

    private synchronized long save(boolean fullSave) throws IOException {
        if (this.deferredIOFailure != null) {
            try {
                throw new IOException(this.deferredIOFailure);
            }
            catch (Throwable throwable) {
                this.deferredIOFailure = null;
                throw throwable;
            }
        }
        if (this.dirty) {
            if (!fullSave && this.keepJournal()) {
                this.forceFlush();
                this.journalOut.close();
                this.journalOut = null;
                return this.journalSize() + this.cacheSize();
            }
            this.dirty = false;
            Path mapTemp = this.mapFile.getRelative(FileSystemUtils.replaceExtension(this.mapFile.asFragment(), ".tmp"));
            try {
                this.saveEntries((Map<K, V>)this.delegate(), mapTemp);
                this.mapFile.delete();
                mapTemp.renameTo(this.mapFile);
            }
            finally {
                mapTemp.delete();
            }
            this.clearJournal();
            this.journalFile.delete();
            return this.cacheSize();
        }
        return this.cacheSize();
    }

    protected final synchronized long journalSize() throws IOException {
        return this.journalFile.exists() ? this.journalFile.getFileSize() : 0L;
    }

    protected final synchronized long cacheSize() throws IOException {
        return this.mapFile.exists() ? this.mapFile.getFileSize() : 0L;
    }

    protected boolean keepJournal() {
        return false;
    }

    private synchronized void clearJournal() throws IOException {
        this.journal.clear();
        if (this.journalOut != null) {
            this.journalOut.close();
            this.journalOut = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void loadEntries(Path mapFile, boolean failFast) throws IOException {
        byte[] mapBytes;
        if (!mapFile.exists()) {
            return;
        }
        long fileSize = mapFile.getFileSize();
        if (fileSize < 16L) {
            if (failFast) {
                throw new IOException(mapFile + " is too short: Only " + fileSize + " bytes");
            }
            return;
        }
        if (fileSize > 0x7FFFFFF7L) {
            if (failFast) {
                throw new IOException(mapFile + " is too long: " + fileSize + " bytes");
            }
            return;
        }
        try (InputStream fileInput = mapFile.getInputStream();){
            mapBytes = ByteStreams.toByteArray(new BufferedInputStream(fileInput));
        }
        try (DataInputStream in = new DataInputStream(new ByteArrayInputStream(mapBytes));){
            if (in.readLong() != 537334021L) {
                if (failFast) {
                    throw new IOException("Unexpected format");
                }
                return;
            }
            if (in.readLong() != (long)this.version) {
                if (failFast) {
                    throw new IOException("Unexpected format");
                }
                return;
            }
            this.readEntries(in, failFast);
        }
        ((GoogleLogger.Api)logger.atInfo()).log("Loaded cache '%s' [%d bytes]", (Object)mapFile, fileSize);
    }

    private synchronized void saveEntries(Map<K, V> map, Path mapFile) throws IOException {
        try (DataOutputStream out = this.createMapFile(mapFile);){
            this.writeEntries(out, map.keySet(), map);
        }
    }

    private synchronized DataOutputStream createMapFile(Path mapFile) throws IOException {
        mapFile.getParentDirectory().createDirectoryAndParents();
        DataOutputStream out = new DataOutputStream(new BufferedOutputStream(mapFile.getOutputStream()));
        out.writeLong(537334021L);
        out.writeLong(this.version);
        return out;
    }

    private void writeEntries(DataOutputStream out, Set<K> keys, Map<K, V> map) throws IOException {
        for (K key : keys) {
            out.writeByte(254);
            this.writeKey(key, out);
            V value = map.get(key);
            boolean isEntry = value != null;
            out.writeBoolean(isEntry);
            if (!isEntry) continue;
            this.writeValue(value, out);
        }
    }

    private void readEntries(DataInputStream in, boolean failFast) throws IOException {
        Object map = this.delegate();
        while (this.hasEntries(in, failFast)) {
            K key = this.readKey(in);
            boolean isEntry = in.readBoolean();
            if (isEntry) {
                V value = this.readValue(in);
                map.put(key, value);
                continue;
            }
            map.remove(key);
        }
    }

    private boolean hasEntries(DataInputStream in, boolean failFast) throws IOException {
        if (in.available() <= 0) {
            return false;
        }
        if (in.readUnsignedByte() != 254) {
            if (failFast) {
                throw new IOException("Corrupted entry separator");
            }
            return false;
        }
        return true;
    }

    protected abstract void writeKey(K var1, DataOutputStream var2) throws IOException;

    protected abstract void writeValue(V var1, DataOutputStream var2) throws IOException;

    protected abstract K readKey(DataInputStream var1) throws IOException;

    protected abstract V readValue(DataInputStream var1) throws IOException;
}

