/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.util;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.devtools.build.lib.vfs.PathFragment;
import com.google.devtools.common.options.Converter;
import java.util.ArrayList;
import java.util.List;

public final class PathFragmentFilter {
    private final List<PathFragment> inclusions;
    private final List<PathFragment> exclusions;

    public PathFragmentFilter(List<PathFragment> inclusions, List<PathFragment> exclusions) {
        this.inclusions = ImmutableList.copyOf(inclusions);
        this.exclusions = ImmutableList.copyOf(exclusions);
    }

    public boolean isIncluded(PathFragment path) {
        for (PathFragment excludedPath : this.exclusions) {
            if (!path.startsWith(excludedPath)) continue;
            return false;
        }
        for (PathFragment includedPath : this.inclusions) {
            if (!path.startsWith(includedPath)) continue;
            return true;
        }
        return this.inclusions.isEmpty();
    }

    public String toString() {
        ArrayList<Object> list = new ArrayList<Object>(this.inclusions.size() + this.exclusions.size());
        for (PathFragment path : this.inclusions) {
            list.add(path.getPathString());
        }
        for (PathFragment path : this.exclusions) {
            list.add("-" + path.getPathString());
        }
        return Joiner.on(',').join(list);
    }

    public static class PathFragmentFilterConverter
    extends Converter.Contextless<PathFragmentFilter> {
        @Override
        public PathFragmentFilter convert(String input) {
            ArrayList<PathFragment> inclusionList = new ArrayList<PathFragment>();
            ArrayList<PathFragment> exclusionList = new ArrayList<PathFragment>();
            for (String piece : Splitter.on(',').split(input)) {
                if (piece.length() > 1 && piece.startsWith("-")) {
                    exclusionList.add(PathFragment.create(piece.substring(1)));
                    continue;
                }
                if (piece.isEmpty()) continue;
                inclusionList.add(PathFragment.create(piece));
            }
            return new PathFragmentFilter(inclusionList, exclusionList);
        }

        @Override
        public String getTypeDescription() {
            return "a comma-separated list of paths with prefix '-' specifying excluded paths";
        }
    }
}

