/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.util;

import java.util.Objects;
import javax.annotation.Nullable;

public final class Pair<A, B> {
    @Nullable
    public final A first;
    @Nullable
    public final B second;

    public static <A, B> Pair<A, B> of(@Nullable A first, @Nullable B second) {
        return new Pair<A, B>(first, second);
    }

    public Pair(@Nullable A first, @Nullable B second) {
        this.first = first;
        this.second = second;
    }

    @Nullable
    public A getFirst() {
        return this.first;
    }

    @Nullable
    public B getSecond() {
        return this.second;
    }

    public String toString() {
        return "(" + this.first + ", " + this.second + ")";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Pair)) {
            return false;
        }
        Pair p = (Pair)o;
        return Objects.equals(this.first, p.first) && Objects.equals(this.second, p.second);
    }

    public int hashCode() {
        int hash1 = this.first == null ? 0 : this.first.hashCode();
        int hash2 = this.second == null ? 0 : this.second.hashCode();
        return 31 * hash1 + hash2;
    }
}

