/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.util;

import com.google.common.base.Preconditions;
import com.google.common.base.StandardSystemProperty;
import com.google.common.collect.ImmutableList;
import com.google.devtools.build.lib.util.ShellEscaper;
import com.google.devtools.build.lib.vfs.PathFragment;
import com.google.devtools.common.options.Converter;
import com.google.devtools.common.options.OptionsParsingException;
import com.google.devtools.common.options.OptionsParsingResult;
import com.google.devtools.common.options.ParsedOptionDescription;
import java.util.List;
import javax.annotation.Nullable;

public final class OptionsUtils {
    public static String asShellEscapedString(Iterable<ParsedOptionDescription> optionsList) {
        StringBuilder result = new StringBuilder();
        for (ParsedOptionDescription option : optionsList) {
            if (option.isHidden()) continue;
            if (result.length() != 0) {
                result.append(' ');
            }
            result.append(option.getCanonicalFormWithValueEscaper(ShellEscaper::escapeString));
        }
        return result.toString();
    }

    public static String asShellEscapedString(OptionsParsingResult options) {
        return OptionsUtils.asShellEscapedString(options.asCompleteListOfParsedOptions());
    }

    public static List<String> asArgumentList(Iterable<ParsedOptionDescription> optionsList) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (ParsedOptionDescription option : optionsList) {
            if (option.isHidden()) continue;
            builder.add(option.getCanonicalForm());
        }
        return builder.build();
    }

    public static List<String> asArgumentList(OptionsParsingResult options) {
        return OptionsUtils.asArgumentList(options.asCompleteListOfParsedOptions());
    }

    public static String asFilteredShellEscapedString(OptionsParsingResult options, Iterable<ParsedOptionDescription> optionsList) {
        return OptionsUtils.asShellEscapedString(optionsList);
    }

    public static String asFilteredShellEscapedString(OptionsParsingResult options) {
        return OptionsUtils.asFilteredShellEscapedString(options, options.asCompleteListOfParsedOptions());
    }

    private static PathFragment convertOptionsPathFragment(String path) {
        if (!path.isEmpty() && path.startsWith("~/")) {
            path = path.replace("~", StandardSystemProperty.USER_HOME.value());
        }
        return PathFragment.create(path);
    }

    public static class PathFragmentListConverter
    extends Converter.Contextless<ImmutableList<PathFragment>> {
        @Override
        public ImmutableList<PathFragment> convert(String input) {
            ImmutableList.Builder result = ImmutableList.builder();
            for (String piece : input.split(":")) {
                if (piece.isEmpty()) continue;
                result.add(OptionsUtils.convertOptionsPathFragment(piece));
            }
            return result.build();
        }

        @Override
        public String getTypeDescription() {
            return "a colon-separated list of paths";
        }
    }

    public static class EmptyToNullRelativePathFragmentConverter
    extends Converter.Contextless<PathFragment> {
        @Override
        @Nullable
        public PathFragment convert(String input) throws OptionsParsingException {
            if (input.isEmpty()) {
                return null;
            }
            PathFragment pathFragment = OptionsUtils.convertOptionsPathFragment(input);
            if (pathFragment.isAbsolute()) {
                throw new OptionsParsingException("Expected relative path but got '" + input + "'.");
            }
            return pathFragment;
        }

        @Override
        public String getTypeDescription() {
            return "a relative path";
        }
    }

    public static class AbsolutePathFragmentConverter
    extends Converter.Contextless<PathFragment> {
        @Override
        public PathFragment convert(String input) throws OptionsParsingException {
            PathFragment parsed = OptionsUtils.convertOptionsPathFragment(Preconditions.checkNotNull(input));
            if (!parsed.isAbsolute()) {
                throw new OptionsParsingException(String.format("Not an absolute path: '%s'", input));
            }
            return parsed;
        }

        @Override
        public String getTypeDescription() {
            return "an absolute path";
        }
    }

    public static class PathFragmentConverter
    extends Converter.Contextless<PathFragment> {
        @Override
        public PathFragment convert(String input) {
            return OptionsUtils.convertOptionsPathFragment(Preconditions.checkNotNull(input));
        }

        @Override
        public String getTypeDescription() {
            return "a path";
        }
    }
}

