/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.util;

import java.util.EnumSet;

public enum OS {
    DARWIN("osx", "Mac OS X"),
    FREEBSD("freebsd", "FreeBSD"),
    OPENBSD("openbsd", "OpenBSD"),
    LINUX("linux", "Linux"),
    WINDOWS("windows", "Windows"),
    UNKNOWN("unknown", "");

    private static final EnumSet<OS> POSIX_COMPATIBLE;
    private final String canonicalName;
    private final String detectionName;
    private static final OS HOST_SYSTEM;

    private OS(String canonicalName, String detectionName) {
        this.canonicalName = canonicalName;
        this.detectionName = detectionName;
    }

    public String getCanonicalName() {
        return this.canonicalName;
    }

    public String toString() {
        return this.getCanonicalName();
    }

    public static OS getCurrent() {
        return HOST_SYSTEM;
    }

    public static boolean isPosixCompatible() {
        return POSIX_COMPATIBLE.contains((Object)OS.getCurrent());
    }

    public static String getVersion() {
        return System.getProperty("os.version");
    }

    private static OS determineCurrentOs() {
        String osName = System.getProperty("blaze.os");
        if (osName == null) {
            osName = System.getProperty("os.name");
        }
        if (osName == null) {
            return UNKNOWN;
        }
        for (OS os : OS.values()) {
            if (!osName.startsWith(os.detectionName)) continue;
            return os;
        }
        return UNKNOWN;
    }

    static {
        POSIX_COMPATIBLE = EnumSet.of(DARWIN, FREEBSD, OPENBSD, LINUX);
        HOST_SYSTEM = OS.determineCurrentOs();
    }
}

