/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.util;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.function.Supplier;

public final class NetUtil {
    private static String hostname = null;
    private static Supplier<String> hostnameSupplier = NetUtil::computeShortHostName;

    private NetUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getCachedShortHostName() {
        if (hostname != null) return hostname;
        Class<NetUtil> clazz = NetUtil.class;
        synchronized (NetUtil.class) {
            if (hostname != null) return hostname;
            hostname = MoreObjects.firstNonNull(hostnameSupplier.get(), "unknown");
            hostnameSupplier = null;
            // ** MonitorExit[var0] (shouldn't be in output)
            return hostname;
        }
    }

    public static synchronized void overrideHostnameSupplier(Supplier<String> override) {
        Preconditions.checkState(hostname == null, "Hostname already set to %s", (Object)hostname);
        hostnameSupplier = Preconditions.checkNotNull(override);
    }

    private static String computeShortHostName() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            return "unknown";
        }
    }
}

