/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.util;

import com.google.common.base.Preconditions;
import java.util.Arrays;

public class LongArrayList {
    private static final int DEFAULT_CAPACITY = 12;
    private long[] array;
    private int size;

    public LongArrayList() {
        this.array = new long[12];
    }

    public LongArrayList(int capacity) {
        Preconditions.checkArgument(capacity >= 0, "Initial capacity must not be negative.");
        this.array = new long[capacity];
    }

    public LongArrayList(long[] array) {
        Preconditions.checkNotNull(array);
        this.array = array;
        this.size = array.length;
    }

    public void add(int position, long value) {
        Preconditions.checkPositionIndex(position, this.size);
        this.copyBackAndGrow(position, 1);
        this.set(position, value);
    }

    public void add(long value) {
        this.add(this.size, value);
    }

    public boolean addAll(LongArrayList other) {
        return this.addAll(other.array, 0, other.size, this.size);
    }

    public boolean addAll(LongArrayList other, int position) {
        return this.addAll(other.array, 0, other.size, position);
    }

    public boolean addAll(long[] array) {
        return this.addAll(array, 0, array.length, this.size);
    }

    public boolean addAll(long[] array, int fromIndex, int length) {
        return this.addAll(array, fromIndex, length, this.size);
    }

    public boolean addAll(long[] array, int fromIndex, int length, int position) {
        Preconditions.checkNotNull(array);
        Preconditions.checkPositionIndex(fromIndex + length, array.length);
        if (length == 0) {
            return false;
        }
        Preconditions.checkElementIndex(fromIndex, array.length);
        Preconditions.checkPositionIndex(position, this.size);
        this.copyBackAndGrow(position, length);
        System.arraycopy(array, fromIndex, this.array, position, length);
        return true;
    }

    public void ensureCapacity(int capacity) {
        if (capacity > this.array.length) {
            long[] newArray = new long[this.growCapacity(capacity)];
            System.arraycopy(this.array, 0, newArray, 0, this.size);
            this.array = newArray;
        }
    }

    public long get(int index) {
        Preconditions.checkElementIndex(index, this.size);
        return this.array[index];
    }

    public int indexOf(long value) {
        for (int index = 0; index < this.size; ++index) {
            if (this.array[index] != value) continue;
            return index;
        }
        return -1;
    }

    public long remove(int index) {
        Preconditions.checkElementIndex(index, this.size);
        long previous = this.array[index];
        System.arraycopy(this.array, index + 1, this.array, index, this.size - index - 1);
        --this.size;
        return previous;
    }

    public boolean remove(long value) {
        int index = this.indexOf(value);
        if (index == -1) {
            return false;
        }
        this.remove(index);
        return true;
    }

    public long set(int index, long value) {
        Preconditions.checkElementIndex(index, this.size);
        long previous = this.array[index];
        this.array[index] = value;
        return previous;
    }

    public int size() {
        return this.size;
    }

    public void sort() {
        Arrays.sort(this.array, 0, this.size);
    }

    public void sort(int fromIndex, int toIndex) {
        Arrays.sort(this.array, fromIndex, toIndex);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("[");
        String separator = "";
        for (int index = 0; index < this.size; ++index) {
            sb.append(separator);
            sb.append(this.array[index]);
            separator = ", ";
        }
        sb.append("]");
        return sb.toString();
    }

    public void trim() {
        if (this.size < this.array.length) {
            long[] newArray = new long[this.size];
            System.arraycopy(this.array, 0, newArray, 0, this.size);
            this.array = newArray;
        }
    }

    private void copyBackAndGrow(int fromIndex, int length) {
        int newSize = this.size + length;
        this.ensureCapacity(newSize);
        System.arraycopy(this.array, fromIndex, this.array, fromIndex + length, this.size - fromIndex);
        this.size = newSize;
    }

    private int growCapacity(int newSize) {
        return newSize + (newSize >> 1);
    }
}

