/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.util;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.Uninterruptibles;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.annotation.Nullable;

public final class LoggingUtil {
    private static Future<Logger> remoteLogger;

    public static synchronized void installRemoteLogger(Future<Logger> logger) {
        Preconditions.checkState(remoteLogger == null);
        remoteLogger = logger;
    }

    public static synchronized void installRemoteLoggerForTesting(Future<Logger> logger) {
        remoteLogger = logger;
    }

    @Nullable
    public static synchronized Logger getRemoteLogger() {
        try {
            return remoteLogger == null ? null : Uninterruptibles.getUninterruptibly(remoteLogger);
        }
        catch (ExecutionException e) {
            throw new RuntimeException("Unexpected error initializing remote logging", e);
        }
    }

    public static void logToRemote(Level level, String msg, Throwable trace) {
        Logger logger = LoggingUtil.getRemoteLogger();
        if (logger != null) {
            logger.log(level, msg, trace);
        }
    }

    public static void logToRemote(Level level, String msg, Throwable trace, String ... values) {
        Logger logger = LoggingUtil.getRemoteLogger();
        if (logger != null) {
            LogRecord logRecord = new LogRecord(level, msg);
            logRecord.setThrown(trace);
            logRecord.setParameters(values);
            logger.log(logRecord);
        }
    }
}

