/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.util;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Suppliers;
import com.google.errorprone.annotations.ForOverride;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.logging.Handler;
import java.util.logging.Logger;

public abstract class LogHandlerQuerier {
    private static final Supplier<LogHandlerQuerier> configuredInstanceSupplier = Suppliers.memoize(LogHandlerQuerier::makeConfiguredInstance);
    protected static final String PROPERTY_NAME = LogHandlerQuerier.class.getName() + ".class";

    private static LogHandlerQuerier makeConfiguredInstance() {
        String subclassName = System.getProperty(PROPERTY_NAME);
        Preconditions.checkNotNull(subclassName, "System property %s is not defined", (Object)PROPERTY_NAME);
        try {
            return (LogHandlerQuerier)ClassLoader.getSystemClassLoader().loadClass(subclassName).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw new ReflectiveOperationRuntimeException("System property " + PROPERTY_NAME + " value is invalid", e);
        }
    }

    static LogHandlerQuerier getConfiguredInstance() throws IOException {
        try {
            return configuredInstanceSupplier.get();
        }
        catch (ReflectiveOperationRuntimeException e) {
            throw new IOException("Could not find a querier for server log location", e.getCause());
        }
    }

    @VisibleForTesting
    public Optional<Path> getLoggerFilePath(Logger logger) throws IOException {
        while (logger != null) {
            for (Handler handler : logger.getHandlers()) {
                if (!this.canQuery(handler)) continue;
                return this.getLogHandlerFilePath(handler);
            }
            logger = logger.getParent();
        }
        throw new IOException("Failed to find a queryable logging handler");
    }

    @ForOverride
    protected abstract boolean canQuery(Handler var1);

    @ForOverride
    protected abstract Optional<Path> getLogHandlerFilePath(Handler var1);

    private static class ReflectiveOperationRuntimeException
    extends RuntimeException {
        private ReflectiveOperationRuntimeException(String message, ReflectiveOperationException exception) {
            super(message, exception);
        }
    }
}

