/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.util;

import com.google.common.base.CharMatcher;
import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.escape.CharEscaper;
import javax.annotation.Nullable;

public final class GccParamFileEscaper
extends CharEscaper {
    public static final GccParamFileEscaper INSTANCE = new GccParamFileEscaper();
    private static final Function<String, String> AS_FUNCTION = INSTANCE.asFunction();
    private static final CharMatcher UNSAFECHAR_MATCHER = CharMatcher.anyOf("'\"\\ \t\r\n\f\u000b").precomputed();

    @Override
    public String escape(String string) {
        if (string.isEmpty()) {
            return "''";
        }
        return super.escape(string);
    }

    @Override
    @Nullable
    public char[] escape(char c) {
        if (!UNSAFECHAR_MATCHER.matches(c)) {
            return null;
        }
        char[] result = new char[]{'\\', c};
        return result;
    }

    public static String escapeString(String unescaped) {
        return INSTANCE.escape(unescaped);
    }

    public static Iterable<String> escapeAll(Iterable<? extends String> unescaped) {
        return Iterables.transform(unescaped, AS_FUNCTION);
    }
}

