/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.util;

import com.google.common.io.ByteStreams;
import com.google.devtools.build.lib.vfs.DigestHashFunction;
import com.google.devtools.build.lib.vfs.Path;
import com.google.devtools.build.lib.vfs.PathFragment;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.protobuf.ByteString;
import com.google.protobuf.CodedOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.DigestException;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.util.Collection;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;

public final class Fingerprint {
    private final CodedOutputStream codedOut;
    private final MessageDigest messageDigest;

    public Fingerprint(DigestHashFunction digestFunction) {
        this.messageDigest = digestFunction.cloneOrCreateMessageDigest();
        this.codedOut = CodedOutputStream.newInstance(new DigestOutputStream(ByteStreams.nullOutputStream(), this.messageDigest), 1024);
    }

    public Fingerprint() {
        this(DigestHashFunction.SHA256);
    }

    public byte[] digestAndReset() {
        try {
            this.codedOut.flush();
        }
        catch (IOException e) {
            throw new IllegalStateException("failed to flush", e);
        }
        return this.messageDigest.digest();
    }

    public void digestAndReset(byte[] buf, int offset, int len) {
        try {
            this.codedOut.flush();
            this.messageDigest.digest(buf, offset, len);
        }
        catch (IOException e) {
            throw new IllegalStateException("failed to flush", e);
        }
        catch (DigestException e) {
            throw new IllegalStateException("failed to digest", e);
        }
    }

    public String hexDigestAndReset() {
        return Fingerprint.hexDigest(this.digestAndReset());
    }

    @CanIgnoreReturnValue
    public Fingerprint addBytes(ByteString bytes) {
        try {
            this.codedOut.writeRawBytes(bytes);
        }
        catch (IOException e) {
            throw new IllegalStateException("failed to write bytes", e);
        }
        return this;
    }

    @CanIgnoreReturnValue
    public Fingerprint addBytes(byte[] input) {
        this.addBytes(input, 0, input.length);
        return this;
    }

    @CanIgnoreReturnValue
    public Fingerprint addBytes(byte[] input, int offset, int len) {
        try {
            this.codedOut.write(input, offset, len);
        }
        catch (IOException e) {
            throw new IllegalStateException("failed to write bytes", e);
        }
        return this;
    }

    @CanIgnoreReturnValue
    public Fingerprint addBoolean(boolean input) {
        try {
            this.codedOut.writeBoolNoTag(input);
        }
        catch (IOException e) {
            throw new IllegalStateException("failed to write bool", e);
        }
        return this;
    }

    @CanIgnoreReturnValue
    public Fingerprint addNullableBoolean(Boolean input) {
        if (input == null) {
            this.addBoolean(false);
        } else {
            this.addBoolean(true);
            this.addBoolean(input);
        }
        return this;
    }

    @CanIgnoreReturnValue
    public Fingerprint addInt(int x) {
        try {
            this.codedOut.writeInt32NoTag(x);
        }
        catch (IOException e) {
            throw new IllegalStateException("failed to write int", e);
        }
        return this;
    }

    @CanIgnoreReturnValue
    public Fingerprint addLong(long x) {
        try {
            this.codedOut.writeInt64NoTag(x);
        }
        catch (IOException e) {
            throw new IllegalStateException("failed to write long", e);
        }
        return this;
    }

    @CanIgnoreReturnValue
    public Fingerprint addNullableInt(@Nullable Integer input) {
        if (input == null) {
            this.addBoolean(false);
        } else {
            this.addBoolean(true);
            this.addInt(input);
        }
        return this;
    }

    @CanIgnoreReturnValue
    public Fingerprint addUUID(UUID uuid) {
        this.addLong(uuid.getLeastSignificantBits());
        this.addLong(uuid.getMostSignificantBits());
        return this;
    }

    @CanIgnoreReturnValue
    public Fingerprint addString(String input) {
        try {
            this.codedOut.writeStringNoTag(input);
        }
        catch (IOException e) {
            throw new IllegalStateException("failed to write string", e);
        }
        return this;
    }

    @CanIgnoreReturnValue
    public Fingerprint addNullableString(@Nullable String input) {
        if (input == null) {
            this.addBoolean(false);
        } else {
            this.addBoolean(true);
            this.addString(input);
        }
        return this;
    }

    @CanIgnoreReturnValue
    public Fingerprint addPath(Path input) {
        this.addString(input.getPathString());
        return this;
    }

    public Fingerprint addPath(PathFragment input) {
        return this.addString(input.getPathString());
    }

    @CanIgnoreReturnValue
    public Fingerprint addStrings(Collection<String> inputs) {
        this.addInt(inputs.size());
        for (String input : inputs) {
            this.addString(input);
        }
        return this;
    }

    @CanIgnoreReturnValue
    public Fingerprint addIterableStrings(Iterable<String> inputs) {
        for (String input : inputs) {
            this.addBoolean(true);
            this.addString(input);
        }
        this.addBoolean(false);
        return this;
    }

    @CanIgnoreReturnValue
    public Fingerprint addStringMap(Map<String, String> inputs) {
        this.addInt(inputs.size());
        for (Map.Entry<String, String> entry : inputs.entrySet()) {
            this.addString(entry.getKey());
            this.addString(entry.getValue());
        }
        return this;
    }

    @CanIgnoreReturnValue
    public Fingerprint addPaths(Collection<PathFragment> inputs) {
        this.addInt(inputs.size());
        for (PathFragment input : inputs) {
            this.addPath(input);
        }
        return this;
    }

    private static String hexDigest(byte[] digest) {
        StringBuilder b = new StringBuilder(32);
        for (int i = 0; i < digest.length; ++i) {
            byte n = digest[i];
            b.append("0123456789abcdef".charAt(n >> 4 & 0xF));
            b.append("0123456789abcdef".charAt(n & 0xF));
        }
        return b.toString();
    }

    public static String getHexDigest(String input) {
        return Fingerprint.hexDigest(DigestHashFunction.SHA256.cloneOrCreateMessageDigest().digest(input.getBytes(StandardCharsets.UTF_8)));
    }
}

