/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.util;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.devtools.build.lib.skyframe.serialization.autocodec.AutoCodec;
import com.google.devtools.build.lib.skyframe.serialization.autocodec.SerializationConstant;
import com.google.devtools.build.lib.util.FileType;
import com.google.devtools.build.lib.util.StringUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.concurrent.Immutable;

@Immutable
public class FileTypeSet
implements Predicate<String> {
    private final ImmutableSet<FileType> fileTypes;
    @SerializationConstant
    public static final FileTypeSet ANY_FILE = new FileTypeSet(){

        @Override
        public String toString() {
            return "any files";
        }

        @Override
        public boolean matches(String filename) {
            return true;
        }

        @Override
        public List<String> getExtensions() {
            return ImmutableList.of();
        }
    };
    @SerializationConstant
    public static final FileTypeSet NO_FILE = new FileTypeSet((Iterable)ImmutableList.of()){

        @Override
        public String toString() {
            return "no files";
        }

        @Override
        public boolean matches(String filename) {
            return false;
        }
    };

    private FileTypeSet() {
        this.fileTypes = null;
    }

    private FileTypeSet(FileType ... fileTypes) {
        this.fileTypes = ImmutableSet.copyOf(fileTypes);
    }

    private FileTypeSet(Iterable<FileType> fileTypes) {
        this.fileTypes = ImmutableSet.copyOf(fileTypes);
    }

    public static FileTypeSet of(FileType ... fileTypes) {
        if (fileTypes.length == 0) {
            return NO_FILE;
        }
        return new FileTypeSet(fileTypes);
    }

    public static FileTypeSet of(Iterable<FileType> fileTypes) {
        if (Iterables.isEmpty(fileTypes)) {
            return NO_FILE;
        }
        return new FileTypeSet(fileTypes);
    }

    public FileTypeSet including(FileType ... fileTypes) {
        return new FileTypeSet(Iterables.concat(this.fileTypes, Arrays.asList(fileTypes)));
    }

    public boolean matches(String path) {
        for (FileType type : this.fileTypes) {
            if (!type.apply(path)) continue;
            return true;
        }
        return false;
    }

    @AutoCodec.VisibleForSerialization
    ImmutableSet<FileType> getFileTypes() {
        return this.fileTypes;
    }

    public boolean isNone() {
        return this == NO_FILE;
    }

    @Override
    public boolean apply(String path) {
        return this.matches(path);
    }

    public List<String> getExtensions() {
        ArrayList<String> extensions = new ArrayList<String>();
        for (FileType type : this.fileTypes) {
            extensions.addAll(type.getExtensions());
        }
        return extensions;
    }

    public String toString() {
        return StringUtil.joinEnglishList(this.getExtensions());
    }
}

