/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.util;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.devtools.build.lib.skyframe.serialization.autocodec.AutoCodec;
import com.google.devtools.build.lib.skyframe.serialization.autocodec.SerializationConstant;
import com.google.devtools.build.lib.util.FileTypeSet;
import com.google.devtools.build.lib.vfs.OsPathPolicy;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.concurrent.Immutable;

@Immutable
public abstract class FileType
implements Predicate<String> {
    private static final OsPathPolicy OS = OsPathPolicy.getFilePathOs();
    @SerializationConstant
    @AutoCodec.VisibleForSerialization
    public static final FileType NO_EXTENSION = new FileType(){

        @Override
        public boolean apply(String path) {
            int lastSlashIndex = path.lastIndexOf(47);
            return path.indexOf(46, lastSlashIndex + 1) == -1;
        }
    };

    public static FileType of(String ext) {
        return new SingletonFileType(ext);
    }

    public static FileType of(ImmutableList<String> extensions) {
        return new ListFileType(extensions);
    }

    public static FileType of(String ... extensions) {
        return FileType.of(ImmutableList.copyOf(extensions));
    }

    public String toString() {
        return this.getExtensions().toString();
    }

    @Override
    public abstract boolean apply(String var1);

    public ImmutableList<String> getExtensions() {
        return ImmutableList.of();
    }

    @Deprecated
    public boolean matches(String path) {
        return this.apply(path);
    }

    public boolean matches(HasFileType item) {
        return this.apply(item.filePathForFileTypeMatcher());
    }

    public static <T extends HasFileType> boolean contains(Iterable<T> items, FileType ... fileTypes) {
        Preconditions.checkState(fileTypes.length > 0, "Must specify at least one file type");
        FileTypeSet fileTypeSet = FileTypeSet.of(fileTypes);
        for (HasFileType item : items) {
            if (!fileTypeSet.matches(item.filePathForFileTypeMatcher())) continue;
            return true;
        }
        return false;
    }

    public static <T extends HasFileType> boolean contains(T item, FileType ... fileTypes) {
        return FileTypeSet.of(fileTypes).matches(item.filePathForFileTypeMatcher());
    }

    private static <T extends HasFileType> Predicate<T> typeMatchingPredicateFor(FileType matchingType) {
        return item -> matchingType.matches(item.filePathForFileTypeMatcher());
    }

    private static <T extends HasFileType> Predicate<T> typeMatchingPredicateFor(FileTypeSet matchingTypes) {
        return item -> matchingTypes.matches(item.filePathForFileTypeMatcher());
    }

    private static <T extends HasFileType> Predicate<T> typeMatchingPredicateFrom(Predicate<String> fileTypePredicate) {
        return item -> fileTypePredicate.apply(item.filePathForFileTypeMatcher());
    }

    public static <T extends HasFileType> Iterable<T> filter(Iterable<T> items, Predicate<String> predicate) {
        return Iterables.filter(items, FileType.typeMatchingPredicateFrom(predicate));
    }

    public static <T extends HasFileType> Iterable<T> filter(Iterable<T> items, FileType ... fileTypes) {
        return FileType.filter(items, FileTypeSet.of(fileTypes));
    }

    public static <T extends HasFileType> Iterable<T> filter(Iterable<T> items, FileTypeSet fileTypes) {
        return Iterables.filter(items, FileType.typeMatchingPredicateFor(fileTypes));
    }

    public static <T extends HasFileType> Iterable<T> filter(Iterable<T> items, FileType fileType) {
        return Iterables.filter(items, FileType.typeMatchingPredicateFor(fileType));
    }

    public static <T extends HasFileType> Iterable<T> except(Iterable<T> items, FileType fileType) {
        return Iterables.filter(items, Predicates.not(FileType.typeMatchingPredicateFor(fileType)));
    }

    public static <T extends HasFileType> List<T> filterList(Iterable<T> items, FileType ... fileTypes) {
        if (fileTypes.length > 0) {
            return FileType.filterList(items, FileTypeSet.of(fileTypes));
        }
        return new ArrayList();
    }

    public static <T extends HasFileType> List<T> filterList(Iterable<T> items, FileType fileType) {
        ArrayList<HasFileType> result = new ArrayList<HasFileType>();
        for (HasFileType item : items) {
            if (!fileType.matches(item.filePathForFileTypeMatcher())) continue;
            result.add(item);
        }
        return result;
    }

    public static <T extends HasFileType> List<T> filterList(Iterable<T> items, FileTypeSet fileTypeSet) {
        ArrayList<HasFileType> result = new ArrayList<HasFileType>();
        for (HasFileType item : items) {
            if (!fileTypeSet.matches(item.filePathForFileTypeMatcher())) continue;
            result.add(item);
        }
        return result;
    }

    public static interface HasFileType {
        public String filePathForFileTypeMatcher();
    }

    private static final class ListFileType
    extends FileType {
        private final ImmutableList<String> extensions;

        ListFileType(ImmutableList<String> extensions) {
            this.extensions = Preconditions.checkNotNull(extensions);
        }

        @Override
        public boolean apply(String path) {
            for (int i = 0; i < this.extensions.size(); ++i) {
                if (!OS.endsWith(path, (String)this.extensions.get(i))) continue;
                return true;
            }
            return false;
        }

        @Override
        public ImmutableList<String> getExtensions() {
            return this.extensions;
        }

        public int hashCode() {
            return this.extensions.hashCode();
        }

        @Override
        public boolean equals(Object obj) {
            return obj instanceof ListFileType && this.extensions.equals(((ListFileType)obj).extensions);
        }
    }

    private static final class SingletonFileType
    extends FileType {
        private final String ext;

        SingletonFileType(String ext) {
            this.ext = ext;
        }

        @Override
        public boolean apply(String path) {
            return OS.endsWith(path, this.ext);
        }

        @Override
        public ImmutableList<String> getExtensions() {
            return ImmutableList.of(this.ext);
        }
    }
}

